/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.util;

import com.liferay.nativity.util.VersionUtil;
import java.io.File;

public class OSDetector {
    public static final String MAC_CHEETAH_10_0 = "10.0";
    public static final String MAC_EL_CAPITAN_10_11 = "10.11";
    public static final String MAC_JAGUAR_10_2 = "10.2";
    public static final String MAC_LEOPARD_10_5 = "10.5";
    public static final String MAC_LION_10_7 = "10.7";
    public static final String MAC_MAVERICKS_10_9 = "10.9";
    public static final String MAC_MOUNTAIN_LION_10_8 = "10.8";
    public static final String MAC_PANTHER_10_3 = "10.3";
    public static final String MAC_PUMA_10_1 = "10.1";
    public static final String MAC_SIERRA_10_12 = "10.12";
    public static final String MAC_SNOW_LEOPARD_10_6 = "10.6";
    public static final String MAC_TIGER_10_4 = "10.4";
    public static final String MAC_YOSEMITE_10_10 = "10.10";
    public static final String WIN_7 = "6.1";
    public static final String WIN_8 = "6.2";
    public static final String WIN_8_1 = "6.3";
    public static final String WIN_10 = "10.0";
    public static final String WIN_2000 = "5.0";
    public static final String WIN_SERVER_2003 = "5.2";
    public static final String WIN_SERVER_2008 = "6.0";
    public static final String WIN_SERVER_2012 = "6.2";
    public static final String WIN_SERVER_2012_R2 = "6.3";
    public static final String WIN_SERVER_2016 = "10.0";
    public static final String WIN_VISTA = "6.0";
    public static final String WIN_XP_X64 = "5.2";
    public static final String WIN_XP_X86 = "5.1";
    private static Boolean _aix;
    private static Boolean _apple;
    private static Boolean _linux;
    private static Boolean _unix;
    private static String _version;
    private static Boolean _windows;

    public static boolean isAIX() {
        if (_aix != null) {
            return _aix;
        }
        String osName = System.getProperty("os.name").toLowerCase();
        _aix = osName.equals("aix") ? Boolean.TRUE : Boolean.FALSE;
        return _aix;
    }

    public static boolean isApple() {
        if (_apple != null) {
            return _apple;
        }
        String osName = System.getProperty("os.name").toLowerCase();
        _apple = osName.contains("mac") ? Boolean.TRUE : Boolean.FALSE;
        return _apple;
    }

    public static boolean isLinux() {
        if (_linux != null) {
            return _linux;
        }
        String osName = System.getProperty("os.name").toLowerCase();
        _linux = osName.contains("linux") ? Boolean.TRUE : Boolean.FALSE;
        return _linux;
    }

    public static boolean isMinimumAppleVersion(String minimumVersion) {
        int compare;
        if (!OSDetector.isApple()) {
            return false;
        }
        if (_version == null) {
            _version = System.getProperty("os.version");
        }
        return (compare = VersionUtil.compare(_version, minimumVersion)) >= 0;
    }

    public static boolean isMinimumWindowsVersion(String minimumVersion) {
        int compare;
        if (!OSDetector.isWindows()) {
            return false;
        }
        if (_version == null) {
            _version = System.getProperty("os.version");
        }
        return (compare = VersionUtil.compare(_version, minimumVersion)) >= 0;
    }

    public static boolean isUnix() {
        if (_unix != null) {
            return _unix;
        }
        _unix = File.pathSeparator.equals(":") ? Boolean.TRUE : Boolean.FALSE;
        return _unix;
    }

    public static boolean isWindows() {
        if (_windows != null) {
            return _windows;
        }
        _windows = File.pathSeparator.equals(";") ? Boolean.TRUE : Boolean.FALSE;
        return _windows;
    }
}

