/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.modules.fileicon.win;

import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.win.WindowsNativityUtil;
import com.liferay.nativity.modules.fileicon.FileIconControlBase;
import com.liferay.nativity.modules.fileicon.FileIconControlCallback;
import com.liferay.nativity.util.win.RegistryUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsFileIconControlImpl
extends FileIconControlBase {
    private static Logger _logger = LoggerFactory.getLogger((String)WindowsFileIconControlImpl.class.getName());

    public WindowsFileIconControlImpl(FileIconControlCallback fileIconControlCallback, NativityControl nativityControl) {
        super(fileIconControlCallback, nativityControl);
    }

    @Override
    public void disableFileIcons() {
        RegistryUtil.writeRegistry("SOFTWARE\\iterate GmbH\\Mountain Duck", "EnableOverlay", 0);
    }

    @Override
    public void enableFileIcons() {
        RegistryUtil.writeRegistry("SOFTWARE\\iterate GmbH\\Mountain Duck", "EnableOverlay", 1);
    }

    @Override
    public void refreshIcons(String[] paths) {
        if (!WindowsNativityUtil.loaded()) {
            return;
        }
        if (paths == null || paths.length == 0) {
            return;
        }
        try {
            for (String path : paths) {
                WindowsNativityUtil.updateExplorer(path);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            _logger.error(ule.getMessage(), (Throwable)ule);
        }
    }

    @Override
    public void refreshWindow(String path) {
        if (!WindowsNativityUtil.loaded()) {
            return;
        }
        WindowsNativityUtil.refreshExplorer(path);
    }

    @Override
    public void registerIconWithId(String path, String label, String iconId) {
    }

    @Override
    public void setFileIcon(String path, int iconId) {
    }

    @Override
    public void setFileIcons(Map<String, Integer> fileIconsMap) {
    }
}

