/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.modules.fileicon.findersync;

import com.liferay.nativity.control.MessageListener;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.NativityMessage;
import com.liferay.nativity.modules.fileicon.FileIconControl;
import com.liferay.nativity.modules.fileicon.FileIconControlCallback;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FSFileIconControlImpl
implements FileIconControl {
    protected FileIconControlCallback fileIconControlCallback;
    protected NativityControl nativityControl;
    private static int _messageBufferSize = 500;

    public FSFileIconControlImpl(FileIconControlCallback fileIconControlCallback, NativityControl nativityControl) {
        this.fileIconControlCallback = fileIconControlCallback;
        this.nativityControl = nativityControl;
        MessageListener messageListener = new MessageListener("getFileIconId"){

            @Override
            public NativityMessage onMessage(NativityMessage message) {
                String filePath = null;
                if (message.getValue() instanceof List) {
                    List args = (List)message.getValue();
                    if (args.size() > 0) {
                        filePath = args.get(0).toString();
                    }
                } else if (message.getValue() != null) {
                    filePath = message.getValue().toString();
                }
                if (filePath == null) {
                    return null;
                }
                int iconId = FSFileIconControlImpl.this.getIconForFile(filePath);
                HashMap<String, Integer> map = new HashMap<String, Integer>(1);
                map.put(filePath, iconId);
                return new NativityMessage("setFileIcons", map);
            }
        };
        nativityControl.registerMessageListener(messageListener);
    }

    @Override
    public void disableFileIcons() {
    }

    @Override
    public void enableFileIcons() {
    }

    @Override
    public int getIconForFile(String path) {
        return this.fileIconControlCallback.getIconForFile(path);
    }

    @Override
    public void refreshIcons(String[] paths) {
        NativityMessage message = new NativityMessage("refreshIcons", Arrays.asList(paths));
        this.nativityControl.sendMessage(message);
    }

    @Override
    public void refreshWindow(String path) {
    }

    @Override
    public void registerIconWithId(String path, String label, String iconId) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("path", path);
        map.put("label", label);
        map.put("iconId", iconId);
        NativityMessage message = new NativityMessage("registerIconWithId", map);
        this.nativityControl.sendMessage(message);
    }

    @Override
    public void setFileIcon(String path, int iconId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        map.put(path, iconId);
        this.setFileIcons(map);
    }

    @Override
    public void setFileIcons(Map<String, Integer> fileIconsMap) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(_messageBufferSize);
        int i = 0;
        for (Map.Entry<String, Integer> entry : fileIconsMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
            if (++i != _messageBufferSize) continue;
            NativityMessage message = new NativityMessage("setFileIcons", map);
            this.nativityControl.sendMessage(message);
            map.clear();
            i = 0;
        }
        if (i > 0) {
            NativityMessage message = new NativityMessage("setFileIcons", map);
            this.nativityControl.sendMessage(message);
        }
    }
}

