/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.modules.fileicon;

import com.liferay.nativity.control.MessageListener;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.NativityMessage;
import com.liferay.nativity.modules.fileicon.FileIconControl;
import com.liferay.nativity.modules.fileicon.FileIconControlCallback;
import java.util.List;

public abstract class FileIconControlBase
implements FileIconControl {
    protected FileIconControlCallback fileIconControlCallback;
    protected NativityControl nativityControl;

    public FileIconControlBase(FileIconControlCallback fileIconControlCallback, NativityControl nativityControl) {
        this.fileIconControlCallback = fileIconControlCallback;
        this.nativityControl = nativityControl;
        MessageListener messageListener = new MessageListener("getFileIconId"){

            @Override
            public NativityMessage onMessage(NativityMessage message) {
                String filePath = null;
                if (message.getValue() instanceof List) {
                    List args = (List)message.getValue();
                    if (args.size() > 0) {
                        filePath = args.get(0).toString();
                    }
                } else if (message.getValue() != null) {
                    filePath = message.getValue().toString();
                }
                int icon = FileIconControlBase.this.getIconForFile(filePath);
                return new NativityMessage("getFileIconId", icon);
            }
        };
        nativityControl.registerMessageListener(messageListener);
    }

    @Override
    public int getIconForFile(String path) {
        return this.fileIconControlCallback.getIconForFile(path);
    }
}

