/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.modules.contextmenu.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuAction;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ContextMenuItem {
    private static final String _SEPARATOR = "_SEPARATOR_";
    private ContextMenuAction _contextMenuAction;
    private List<ContextMenuItem> _contextMenuItems;
    private boolean _enabled;
    private String _helpText = "";
    private String _iconId = "";
    private String _iconPath = "";
    private String _title = "";
    private String _uuid = "";

    public ContextMenuItem(String title) {
        this._title = title;
        this._contextMenuItems = new ArrayList<ContextMenuItem>();
        this._enabled = true;
        this._uuid = UUID.randomUUID().toString();
    }

    public ContextMenuItem(String title, ContextMenuItem parentContextMenuItem) {
        this(title);
        parentContextMenuItem.addContextMenuItem(this);
    }

    public boolean addContextMenuItem(ContextMenuItem menuItem) {
        return this._contextMenuItems.add(menuItem);
    }

    public void addContextMenuItem(ContextMenuItem menuItem, int index) {
        this._contextMenuItems.add(index, menuItem);
    }

    public boolean addSeparator() {
        return this._contextMenuItems.add(ContextMenuItem._getSeparator());
    }

    public void addSeparator(int index) {
        this._contextMenuItems.add(index, ContextMenuItem._getSeparator());
    }

    public void fireContextMenuAction(String[] paths, Object window) {
        if (this._contextMenuAction != null) {
            this._contextMenuAction.onSelection(paths, window);
        }
    }

    @JsonIgnore
    public List<ContextMenuItem> getAllContextMenuItems() {
        ArrayList<ContextMenuItem> contextMenuItems = new ArrayList<ContextMenuItem>();
        contextMenuItems.add(this);
        this._addChildren(this, contextMenuItems);
        return contextMenuItems;
    }

    public List<ContextMenuItem> getContextMenuItems() {
        return this._contextMenuItems;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public String getHelpText() {
        return this._helpText;
    }

    public String getIconPath() {
        return this._iconPath;
    }

    public String getTitle() {
        return this._title;
    }

    public String getUuid() {
        return this._uuid;
    }

    public boolean removeContextMenuItem(ContextMenuItem menuItem) {
        return this._contextMenuItems.remove(menuItem);
    }

    public void setContextMenuAction(ContextMenuAction contextMenuAction) {
        this._contextMenuAction = contextMenuAction;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setHelpText(String helpText) {
        this._helpText = helpText;
    }

    public void setIconPath(String iconPath) {
        this._iconPath = iconPath;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String toString() {
        return this._title + " (" + this._uuid + ") " + this._contextMenuItems.size();
    }

    private static ContextMenuItem _getSeparator() {
        return new ContextMenuItem(_SEPARATOR);
    }

    private void _addChildren(ContextMenuItem contextMenuItem, List<ContextMenuItem> contextMenuItems) {
        for (ContextMenuItem childContextMenuItem : contextMenuItem.getContextMenuItems()) {
            contextMenuItems.add(childContextMenuItem);
            this._addChildren(childContextMenuItem, contextMenuItems);
        }
    }
}

