/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.modules.contextmenu;

import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.modules.contextmenu.ContextMenuControlCallback;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextMenuControl
implements ContextMenuControlCallback {
    protected ContextMenuControlCallback contextMenuControlCallback;
    protected List<ContextMenuItem> contextMenuItems;
    protected NativityControl nativityControl;
    private static Logger _logger = LoggerFactory.getLogger((String)ContextMenuControl.class.getName());

    public ContextMenuControl(NativityControl nativityControl, ContextMenuControlCallback contextMenuControlCallback) {
        this.nativityControl = nativityControl;
        this.contextMenuControlCallback = contextMenuControlCallback;
        this.contextMenuItems = new CopyOnWriteArrayList<ContextMenuItem>();
    }

    public void fireContextMenuAction(String uuid, Object window, String[] paths) {
        for (ContextMenuItem contextMenuItem : this.contextMenuItems) {
            if (!contextMenuItem.getUuid().equals(uuid)) continue;
            _logger.trace("Firing action uuid: {} for: {}", (Object)uuid, (Object)paths);
            contextMenuItem.fireContextMenuAction(paths, window);
            break;
        }
    }

    @Override
    public List<ContextMenuItem> getContextMenuItems(String[] paths) {
        List<ContextMenuItem> newContextMenuItems = this.contextMenuControlCallback.getContextMenuItems(paths);
        this.contextMenuItems.clear();
        if (newContextMenuItems == null) {
            return null;
        }
        for (ContextMenuItem contextMenuItem : newContextMenuItems) {
            this.contextMenuItems.addAll(contextMenuItem.getAllContextMenuItems());
        }
        return newContextMenuItems;
    }
}

