/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.control.win;

import com.liferay.nativity.util.OSDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsNativityUtil {
    private static final String _NATIVITY_DLL_NAME = "LiferayNativityWindowsUtil";
    private static Logger _logger = LoggerFactory.getLogger((String)WindowsNativityUtil.class.getName());
    private static boolean _loaded = false;

    public static native boolean addFavoritesPath(String var0);

    public static boolean load() {
        if (!_loaded) {
            WindowsNativityUtil._load();
        }
        return _loaded;
    }

    public static boolean loaded() {
        return _loaded;
    }

    public static native boolean refreshExplorer(String var0);

    public static native boolean removeFavoritesPath(String var0);

    public static native boolean setSystemFolder(String var0);

    public static native boolean updateExplorer(String var0);

    private static void _load() {
        if (!OSDetector.isMinimumWindowsVersion("6.0")) {
            _logger.error("Liferay Nativity is not compatible on Windows Vista or lower");
            return;
        }
        _logger.trace("Loading WindowsNativityUtil DLL");
        String architecture = System.getProperty("sun.arch.data.model").equals("32") ? "x86" : "x64";
        try {
            System.loadLibrary("LiferayNativityWindowsUtil_" + architecture);
            _loaded = true;
            _logger.trace("Loaded WindowsNativityUtil DLL");
        }
        catch (UnsatisfiedLinkError ule) {
            _logger.error("Failed to load WindowsNativityUtil DLL");
        }
    }
}

