/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.control.win;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.NativityMessage;
import com.liferay.nativity.control.win.MessageProcessor;
import com.liferay.nativity.control.win.WindowsNativityUtil;
import com.liferay.nativity.util.win.RegistryUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsNativityControlImpl
extends NativityControl {
    private static Logger _logger = LoggerFactory.getLogger((String)WindowsNativityControlImpl.class.getName());
    private static ObjectMapper _objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    private static int _port = 33001;
    private boolean _connected = false;
    private ExecutorService _executor = Executors.newCachedThreadPool();
    private ServerSocket _serverSocket;

    @Override
    public void addFavoritesPath(String path) {
        WindowsNativityUtil.addFavoritesPath(path);
    }

    @Override
    public boolean connect() {
        if (this._connected) {
            return true;
        }
        boolean loaded = WindowsNativityUtil.load();
        if (!loaded) {
            _logger.debug("WindowsNativityUtil failed to load");
            return false;
        }
        if (!this.createSocket()) {
            return false;
        }
        this._connected = true;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WindowsNativityControlImpl.this.fireSocketOpenListeners();
                while (WindowsNativityControlImpl.this._connected) {
                    WindowsNativityControlImpl.this.handleConnection();
                }
            }
        };
        if (this._executor.isShutdown()) {
            this._executor = Executors.newCachedThreadPool();
        }
        this._executor.execute(runnable);
        return true;
    }

    boolean createSocket() {
        int retries = 0;
        Random random = new Random();
        IOException socketThrowable = new IOException();
        try {
            if (this._serverSocket == null || this._serverSocket.isClosed()) {
                this._serverSocket = new ServerSocket();
            }
            while (retries++ < 5) {
                _port = random.nextInt(16384) + 49152;
                try {
                    InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), _port);
                    this._serverSocket.bind(socketAddress, 50);
                    RegistryUtil.writeRegistry("SOFTWARE\\iterate GmbH\\Mountain Duck", "Port", _port);
                    return true;
                }
                catch (IOException ioe) {
                    socketThrowable.addSuppressed(ioe);
                }
            }
            throw socketThrowable;
        }
        catch (IOException ex) {
            _logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean disconnect() {
        try {
            if (!this._connected) {
                boolean bl = true;
                return bl;
            }
            this._serverSocket.close();
        }
        catch (IOException e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this._executor.shutdown();
        }
        this._connected = false;
        return true;
    }

    @Override
    public Set<String> getAllObservedFolders() {
        return null;
    }

    @Override
    public boolean load() throws Exception {
        return true;
    }

    @Override
    public boolean loaded() {
        return true;
    }

    @Override
    public void refreshFiles(String[] paths) {
        if (paths == null || paths.length == 0) {
            return;
        }
        if (!WindowsNativityUtil.loaded()) {
            return;
        }
        try {
            for (String path : paths) {
                WindowsNativityUtil.updateExplorer(path);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            _logger.error(ule.getMessage(), (Throwable)ule);
        }
    }

    @Override
    public void removeFavoritesPath(String path) {
        WindowsNativityUtil.removeFavoritesPath(path);
    }

    @Override
    public String sendMessage(NativityMessage nativityMessage) {
        return "";
    }

    @Override
    public void setFilterFolder(String folder) {
        this.setFilterFolders(new String[]{folder});
    }

    @Override
    public void setFilterFolders(String[] folders) {
        try {
            String foldersJson = _objectMapper.writeValueAsString((Object)folders);
            RegistryUtil.writeRegistry("SOFTWARE\\iterate GmbH\\Mountain Duck", "FilterFolders", foldersJson);
        }
        catch (JsonProcessingException jpe) {
            _logger.error(jpe.getMessage(), (Throwable)jpe);
        }
        for (String folder : folders) {
            WindowsNativityUtil.refreshExplorer(folder);
        }
    }

    @Override
    public void setPortFilePath(String path) {
    }

    @Override
    public void setSystemFolder(String folder) {
        if (!WindowsNativityUtil.loaded()) {
            return;
        }
        try {
            WindowsNativityUtil.setSystemFolder(folder);
        }
        catch (UnsatisfiedLinkError ule) {
            _logger.error(ule.getMessage(), (Throwable)ule);
        }
    }

    @Override
    public boolean unload() throws Exception {
        return true;
    }

    protected void handleConnection() {
        try {
            Socket clientSocket = this._serverSocket.accept();
            this._executor.execute(new MessageProcessor(clientSocket, this));
        }
        catch (SocketException se) {
            this.fireSocketCloseListeners();
        }
        catch (IOException e) {
            _logger.error(e.getMessage(), (Throwable)e);
            this.fireSocketCloseListeners();
        }
    }
}

