/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.control.win;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.NativityMessage;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProcessor
implements Runnable {
    private static Logger _logger = LoggerFactory.getLogger((String)MessageProcessor.class.getName());
    private static ObjectMapper _objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    private Socket _clientSocket;
    private InputStreamReader _inputStreamReader;
    private NativityControl _nativityControl;
    private OutputStreamWriter _outputStreamWriter;

    public MessageProcessor(Socket clientSocket, NativityControl nativityControl) {
        this._clientSocket = clientSocket;
        this._nativityControl = nativityControl;
    }

    @Override
    public void run() {
        this._init();
        try {
            int character;
            StringBuilder sb = new StringBuilder();
            while ((character = this._inputStreamReader.read()) != -1) {
                sb.append((char)character);
            }
            String message = sb.toString();
            if (message.isEmpty()) {
                this._returnEmpty();
            } else {
                this._handle(message);
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this._inputStreamReader.close();
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handle(String receivedMessage) throws IOException {
        try {
            NativityMessage message = (NativityMessage)_objectMapper.readValue(receivedMessage, NativityMessage.class);
            NativityMessage responseMessage = this._nativityControl.fireMessage(message);
            if (responseMessage == null) {
                this._returnEmpty();
            } else {
                _objectMapper.writeValue((Writer)this._outputStreamWriter, (Object)responseMessage);
                this._outputStreamWriter.write("\u0000");
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (!this._clientSocket.isOutputShutdown()) {
                this._outputStreamWriter.close();
            }
        }
    }

    private void _init() {
        try {
            this._inputStreamReader = new InputStreamReader(this._clientSocket.getInputStream(), Charset.forName("UTF-16LE"));
            this._outputStreamWriter = new OutputStreamWriter(this._clientSocket.getOutputStream(), Charset.forName("UTF-16LE"));
        }
        catch (IOException e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void _returnEmpty() {
        try {
            this._outputStreamWriter.close();
        }
        catch (IOException e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

