/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.control.unix;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.NativityMessage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UnixNativityControlBaseImpl
extends NativityControl {
    private static final String _RETURN_NEW_LINE = "\r\n";
    private static Logger _logger = LoggerFactory.getLogger((String)UnixNativityControlBaseImpl.class.getName());
    private static int _callbackSocketPort = 33002;
    private static int _commandSocketPort = 33001;
    private static ObjectMapper _objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    private BufferedReader _callbackBufferedReader;
    private DataOutputStream _callbackOutputStream;
    private Socket _callbackSocket;
    private ReadThread _callbackThread;
    private BufferedReader _commandBufferedReader;
    private DataOutputStream _commandOutputStream;
    private Socket _commandSocket;
    private boolean _connected = false;

    @Override
    public void addFavoritesPath(String path) {
    }

    @Override
    public boolean connect() {
        try {
            this._commandSocket = new Socket("127.0.0.1", _commandSocketPort);
            this._commandBufferedReader = new BufferedReader(new InputStreamReader(this._commandSocket.getInputStream(), "UTF-8"));
            this._commandOutputStream = new DataOutputStream(this._commandSocket.getOutputStream());
            this._callbackSocket = new Socket("127.0.0.1", _callbackSocketPort);
            this._callbackBufferedReader = new BufferedReader(new InputStreamReader(this._callbackSocket.getInputStream(), "UTF-8"));
            this._callbackOutputStream = new DataOutputStream(this._callbackSocket.getOutputStream());
            this._callbackThread = new ReadThread(this);
            this._callbackThread.start();
            this._connected = true;
            if (_logger.isDebugEnabled()) {
                _logger.debug("Successfully connected to command socket: {}", (Object)_commandSocketPort);
                _logger.debug("Successfully connected to service socket: {}", (Object)_callbackSocketPort);
            }
            return true;
        }
        catch (IOException e) {
            _logger.error(e.getMessage());
            this._connected = false;
            return false;
        }
    }

    @Override
    public boolean disconnect() {
        try {
            this._commandSocket.close();
            this._callbackSocket.close();
            this._connected = false;
            if (_logger.isDebugEnabled()) {
                _logger.debug("Successfully disconnected");
            }
            return true;
        }
        catch (IOException e) {
            _logger.error(e.getMessage(), (Throwable)e);
            this._connected = true;
            return false;
        }
    }

    @Override
    public Set<String> getAllObservedFolders() {
        return null;
    }

    @Override
    public void refreshFiles(String[] paths) {
    }

    @Override
    public void removeFavoritesPath(String path) {
    }

    @Override
    public String sendMessage(NativityMessage message) {
        if (!this._connected) {
            _logger.debug("LiferayNativity is not connected");
            return "";
        }
        try {
            String messageString = _objectMapper.writeValueAsString((Object)message);
            this._commandOutputStream.write(messageString.getBytes("UTF-8"));
            this._commandOutputStream.write(_RETURN_NEW_LINE.getBytes("UTF-8"));
            if (_logger.isTraceEnabled()) {
                _logger.trace("Sent on socket {}: {}", (Object)_commandSocketPort, (Object)messageString);
            }
            String reply = this._commandBufferedReader.readLine();
            if (_logger.isTraceEnabled()) {
                _logger.trace("Received on socket {}: {}", (Object)_commandSocketPort, (Object)reply);
            }
            if (reply == null) {
                this._commandSocket.close();
                this.fireSocketCloseListeners();
            }
            return reply;
        }
        catch (IOException e) {
            _logger.error(e.getMessage(), (Throwable)e);
            this.fireSocketCloseListeners();
            return "";
        }
    }

    @Override
    public void setPortFilePath(String path) {
    }

    @Override
    public void setSystemFolder(String folder) {
    }

    private void _doCallbackLoop() {
        if (!this._connected) {
            _logger.debug("LiferayNativity is not connected");
            return;
        }
        while (this._connected) {
            try {
                NativityMessage message;
                NativityMessage responseMessage;
                String data = this._callbackBufferedReader.readLine();
                if (_logger.isTraceEnabled()) {
                    _logger.trace("Received on socket {}: {}", (Object)_callbackSocketPort, (Object)data);
                }
                if (data == null) {
                    this.disconnect();
                    this.fireSocketCloseListeners();
                    break;
                }
                if (data.isEmpty() || (responseMessage = this.fireMessage(message = (NativityMessage)_objectMapper.readValue(data, NativityMessage.class))) == null) continue;
                String responseMessageString = _objectMapper.writeValueAsString((Object)responseMessage);
                this._callbackOutputStream.write(responseMessageString.getBytes("UTF-8"));
                this._callbackOutputStream.write(_RETURN_NEW_LINE.getBytes("UTF-8"));
                if (!_logger.isTraceEnabled()) continue;
                _logger.trace("Sent on socket {}: {}", (Object)_callbackSocketPort, (Object)responseMessageString);
            }
            catch (IOException ioe) {
                if (!(ioe instanceof SocketException)) {
                    _logger.error(ioe.getMessage(), (Throwable)ioe);
                }
                this.disconnect();
                this.fireSocketCloseListeners();
            }
        }
    }

    protected class ReadThread
    extends Thread {
        private UnixNativityControlBaseImpl _pluginControl;

        public ReadThread(UnixNativityControlBaseImpl pluginControl) {
            this._pluginControl = pluginControl;
        }

        @Override
        public void run() {
            this._pluginControl._doCallbackLoop();
        }
    }
}

