/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.control.findersync;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.NativityMessage;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSNativityControlImpl
extends NativityControl {
    private static final byte[] _RETURN_NEW_LINE = "\r\n".getBytes();
    private static Logger _logger = LoggerFactory.getLogger((String)FSNativityControlImpl.class.getName());
    private static ObjectMapper _objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    private ChannelGroup _channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private EventLoopGroup _childEventLoopGroup;
    private boolean _connected;
    private List<FinderSyncChannelHandler> _finderSyncChannelHandlers = new CopyOnWriteArrayList<FinderSyncChannelHandler>();
    private EventLoopGroup _parentEventLoopGroup;
    private String _portFilePath;

    @Override
    public void addFavoritesPath(String path) {
        NativityMessage message = new NativityMessage("addFavoritesPath", path);
        this.sendMessage(message);
    }

    @Override
    public boolean connect() {
        if (this._connected) {
            return true;
        }
        this._childEventLoopGroup = new NioEventLoopGroup();
        this._parentEventLoopGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            serverBootstrap.group(this._parentEventLoopGroup, this._childEventLoopGroup);
            serverBootstrap.channel(NioServerSocketChannel.class);
            ChannelInitializer<SocketChannel> channelInitializer = new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    DelimiterBasedFrameDecoder messageDecoder = new DelimiterBasedFrameDecoder(Integer.MAX_VALUE, Delimiters.lineDelimiter());
                    FinderSyncChannelHandler finderSyncChannelHandler = new FinderSyncChannelHandler();
                    socketChannel.pipeline().addLast(new ChannelHandler[]{messageDecoder, finderSyncChannelHandler});
                }
            };
            serverBootstrap.childHandler((ChannelHandler)channelInitializer);
            serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture channelFuture = serverBootstrap.bind(InetAddress.getLoopbackAddress(), 0).sync();
            InetSocketAddress inetSocketAddress = (InetSocketAddress)channelFuture.channel().localAddress();
            this.connected(inetSocketAddress.getPort());
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            this._connected = false;
            return false;
        }
        this._connected = true;
        return true;
    }

    @Override
    public boolean disconnect() {
        if (!this._connected) {
            return true;
        }
        this._childEventLoopGroup.shutdownGracefully();
        this._parentEventLoopGroup.shutdownGracefully();
        this._connected = false;
        return true;
    }

    @Override
    public Set<String> getAllObservedFolders() {
        HashSet<String> observedFolders = new HashSet<String>();
        for (FinderSyncChannelHandler finderSyncChannelHandler : this._finderSyncChannelHandlers) {
            observedFolders.addAll(finderSyncChannelHandler.getObservedFolders());
        }
        return observedFolders;
    }

    @Override
    public boolean load() throws Exception {
        return true;
    }

    @Override
    public boolean loaded() {
        return true;
    }

    @Override
    public void refreshFiles(String[] paths) {
    }

    @Override
    public void removeFavoritesPath(String path) {
        NativityMessage message = new NativityMessage("removeFavoritesPath", path);
        this.sendMessage(message);
    }

    @Override
    public String sendMessage(NativityMessage message) {
        try {
            byte[] messageBytes = _objectMapper.writeValueAsBytes((Object)message);
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[][])new byte[][]{messageBytes, _RETURN_NEW_LINE});
            this._channelGroup.writeAndFlush((Object)byteBuf);
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    @Override
    public void setFilterFolder(String folder) {
        this.setFilterFolders(new String[]{folder});
    }

    @Override
    public void setFilterFolders(String[] folders) {
        NativityMessage message = new NativityMessage("setFilterPaths", folders);
        this.sendMessage(message);
    }

    @Override
    public void setPortFilePath(String path) {
        this._portFilePath = path;
    }

    @Override
    public void setSystemFolder(String folder) {
    }

    @Override
    public boolean unload() throws Exception {
        return false;
    }

    protected void connected(int port) {
        String path = null;
        path = this._portFilePath == null ? System.getProperty("user.home") + "/.liferay-nativity/port" : this._portFilePath;
        final File file = new File(path);
        PrintWriter writer = null;
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            writer = new PrintWriter(path);
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        writer.println(String.valueOf(port));
        writer.close();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    file.delete();
                }
                catch (Exception e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
    }

    private class FinderSyncChannelHandler
    extends ChannelInboundHandlerAdapter {
        private Set<String> _observedFolders = Collections.newSetFromMap(new ConcurrentHashMap());

        private FinderSyncChannelHandler() {
        }

        public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
            super.channelActive(channelHandlerContext);
            FSNativityControlImpl.this._finderSyncChannelHandlers.add(this);
            FSNativityControlImpl.this._channelGroup.add((Object)channelHandlerContext.channel());
            FSNativityControlImpl.this.fireSocketOpenListeners();
        }

        public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            super.channelInactive(channelHandlerContext);
            FSNativityControlImpl.this._finderSyncChannelHandlers.remove((Object)this);
            FSNativityControlImpl.this._channelGroup.remove((Object)channelHandlerContext.channel());
            FSNativityControlImpl.this.fireSocketCloseListeners();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object messageObj) {
            NativityMessage nativityMessage;
            ByteBuf readByteBuf;
            block11: {
                block10: {
                    String messageStr;
                    block9: {
                        readByteBuf = (ByteBuf)messageObj;
                        messageStr = readByteBuf.toString(CharsetUtil.UTF_8);
                        if (!messageStr.isEmpty()) break block9;
                        readByteBuf.release();
                        return;
                    }
                    nativityMessage = (NativityMessage)_objectMapper.readValue(messageStr, NativityMessage.class);
                    if (!nativityMessage.getCommand().equals("startObservingFolder")) break block10;
                    this._observedFolders.add(nativityMessage.getValue().toString());
                    readByteBuf.release();
                    return;
                }
                if (!nativityMessage.getCommand().equals("endObservingFolder")) break block11;
                this._observedFolders.remove(nativityMessage.getValue().toString());
                readByteBuf.release();
                return;
            }
            try {
                try {
                    NativityMessage responseMessage = FSNativityControlImpl.this.fireMessage(nativityMessage);
                    if (responseMessage != null) {
                        byte[] responseMessageBytes = _objectMapper.writeValueAsBytes((Object)responseMessage);
                        ByteBuf writeByteBuf = Unpooled.wrappedBuffer((byte[][])new byte[][]{responseMessageBytes, _RETURN_NEW_LINE});
                        channelHandlerContext.writeAndFlush((Object)writeByteBuf);
                    }
                }
                catch (Exception e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                readByteBuf.release();
            }
        }

        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            _logger.error(throwable.getMessage(), throwable);
            channelHandlerContext.close();
            FSNativityControlImpl.this.fireSocketCloseListeners();
        }

        public Set<String> getObservedFolders() {
            return this._observedFolders;
        }
    }
}

