/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.control;

import com.liferay.nativity.control.MessageListener;
import com.liferay.nativity.control.NativityMessage;
import com.liferay.nativity.listeners.SocketCloseListener;
import com.liferay.nativity.listeners.SocketOpenListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NativityControl {
    protected List<SocketCloseListener> socketCloseListeners;
    protected List<SocketOpenListener> socketOpenListeners;
    private static Logger _logger = LoggerFactory.getLogger((String)NativityControl.class.getName());
    private Map<String, MessageListener> _commandMap = new ConcurrentHashMap<String, MessageListener>();

    public NativityControl() {
        this.socketCloseListeners = new CopyOnWriteArrayList<SocketCloseListener>();
        this.socketOpenListeners = new CopyOnWriteArrayList<SocketOpenListener>();
    }

    public abstract void addFavoritesPath(String var1);

    public void addSocketCloseListener(SocketCloseListener socketCloseListener) {
        this.socketCloseListeners.add(socketCloseListener);
    }

    public void addSocketOpenListener(SocketOpenListener socketOpenListener) {
        this.socketOpenListeners.add(socketOpenListener);
    }

    public abstract boolean connect();

    public abstract boolean disconnect();

    public NativityMessage fireMessage(NativityMessage message) {
        _logger.trace("Firing message: {}", (Object)message.getCommand());
        MessageListener messageListener = this._commandMap.get(message.getCommand());
        if (messageListener == null) {
            return null;
        }
        return messageListener.onMessage(message);
    }

    public void fireSocketCloseListeners() {
        for (SocketCloseListener listener : this.socketCloseListeners) {
            listener.onSocketClose();
        }
    }

    public void fireSocketOpenListeners() {
        for (SocketOpenListener listener : this.socketOpenListeners) {
            listener.onSocketOpen();
        }
    }

    public abstract Set<String> getAllObservedFolders();

    public abstract boolean load() throws Exception;

    public abstract boolean loaded();

    @Deprecated
    public abstract void refreshFiles(String[] var1);

    public void registerMessageListener(MessageListener messageListener) {
        this._commandMap.put(messageListener.getCommand(), messageListener);
    }

    public abstract void removeFavoritesPath(String var1);

    public void removeSocketCloseListener(SocketCloseListener socketCloseListener) {
        this.socketCloseListeners.remove(socketCloseListener);
    }

    public void removeSocketOpenListener(SocketOpenListener socketOpenListener) {
        this.socketOpenListeners.remove(socketOpenListener);
    }

    public abstract String sendMessage(NativityMessage var1);

    public abstract void setFilterFolder(String var1);

    public abstract void setFilterFolders(String[] var1);

    public abstract void setPortFilePath(String var1);

    @Deprecated
    public abstract void setSystemFolder(String var1);

    public abstract boolean unload() throws Exception;
}

