/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.vfs;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.ExportTable;
import org.dcache.nfs.FsExport;
import org.dcache.nfs.status.AccessException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.status.PermException;
import org.dcache.nfs.status.RoFsException;
import org.dcache.nfs.util.SubjectHolder;
import org.dcache.nfs.util.UnixSubjects;
import org.dcache.nfs.v4.acl.Acls;
import org.dcache.nfs.v4.xdr.acemask4;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.vfs.AclCheckable;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.DirectoryStream;
import org.dcache.nfs.vfs.FileHandle;
import org.dcache.nfs.vfs.ForwardingFileSystem;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.PseudoFsNode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.oncrpc4j.rpc.RpcAuth;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.gss.RpcAuthGss;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoFs
extends ForwardingFileSystem {
    private static final Logger _log = LoggerFactory.getLogger(PseudoFs.class);
    public static final int PRIVILEGED_PORT = 1023;
    private final Subject _subject;
    private final InetSocketAddress _inetAddress;
    private final VirtualFileSystem _inner;
    private final ExportTable _exportTable;
    private final RpcAuth _auth;
    private static final int ACCESS4_MASK = 511;
    private static final int BIT_MASK_OWNER_OFFSET = 6;
    private static final int BIT_MASK_GROUP_OFFSET = 3;
    private static final int BIT_MASK_OTHER_OFFSET = 0;

    public PseudoFs(VirtualFileSystem inner, RpcCall call, ExportTable exportTable) {
        this._inner = inner;
        this._subject = call.getCredential().getSubject();
        this._auth = call.getCredential();
        this._inetAddress = call.getTransport().getRemoteSocketAddress();
        this._exportTable = exportTable;
    }

    @Override
    protected VirtualFileSystem delegate() {
        return this._inner;
    }

    private boolean canAccess(Inode inode, Stat stat, int mode) {
        try {
            this.checkAccess(inode, stat, mode, false);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public int access(Subject subject, Inode inode, int mode) throws IOException {
        int accessmask = 0;
        if ((mode & 0xFFFFFE00) != 0) {
            throw new InvalException("invalid access mask");
        }
        Stat stat = this._inner.getattr(inode);
        if ((mode & 1) != 0 && this.canAccess(inode, stat, 1)) {
            accessmask |= 1;
        }
        if ((mode & 2) != 0 && this.canAccess(inode, stat, 32)) {
            accessmask |= 2;
        }
        if ((mode & 4) != 0 && this.canAccess(inode, stat, 2)) {
            accessmask |= 4;
        }
        if ((mode & 0x20) != 0 && this.canAccess(inode, stat, 32)) {
            accessmask |= 0x20;
        }
        if ((mode & 8) != 0 && this.canAccess(inode, stat, 4)) {
            accessmask |= 8;
        }
        if ((mode & 0x10) != 0 && this.canAccess(inode, stat, 64)) {
            accessmask |= 0x10;
        }
        if ((mode & 0x40) != 0 && this.canAccess(inode, stat, 1)) {
            accessmask |= 0x40;
        }
        if ((mode & 0x100) != 0 && this.canAccess(inode, stat, 1)) {
            accessmask |= 0x100;
        }
        if ((mode & 0x80) != 0 && this.canAccess(inode, stat, 2)) {
            accessmask |= 0x80;
        }
        return accessmask & this._inner.access(subject, inode, accessmask);
    }

    @Override
    public Inode create(Inode parent, Stat.Type type, String path, Subject subject, int mode) throws IOException {
        Subject effectiveSubject = this.checkAccess(parent, 2);
        if (subject != null && UnixSubjects.isRootSubject(effectiveSubject)) {
            effectiveSubject = subject;
        }
        if (this.inheritUidGid(parent)) {
            Stat s = this._inner.getattr(parent);
            effectiveSubject = UnixSubjects.toSubject(s.getUid(), s.getGid());
        }
        return this.pushExportIndex(parent, this._inner.create(parent, type, path, effectiveSubject, mode));
    }

    @Override
    public Inode getRootInode() throws IOException {
        if (!this._exportTable.exports(this._inetAddress.getAddress()).findAny().isPresent()) {
            _log.warn("Access denied: (no export) fs root for client {}", (Object)this._inetAddress);
            throw new AccessException("no exports");
        }
        Inode inode = this._inner.getRootInode();
        FsExport export = this._exportTable.getExport("/", this._inetAddress.getAddress());
        return export == null ? this.realToPseudo(inode) : this.pushExportIndex(inode, export.getIndex());
    }

    @Override
    public Inode lookup(Inode parent, String path) throws IOException {
        if (parent.isPseudoInode()) {
            return this.lookupInPseudoDirectory(parent, path);
        }
        FsExport export = this._exportTable.getExport(parent.exportIndex(), this._inetAddress.getAddress());
        if (!export.isWithDcap() && ".(get)(cursor)".equals(path)) {
            throw new NoEntException("the dcap magic file is blocked");
        }
        return this.pushExportIndex(parent, this._inner.lookup(parent, path));
    }

    @Override
    public Inode link(Inode parent, Inode link, String path, Subject subject) throws IOException {
        this.checkAccess(link, 256);
        Subject effectiveSubject = this.checkAccess(parent, 2);
        if (this.inheritUidGid(parent)) {
            Stat s = this._inner.getattr(parent);
            effectiveSubject = UnixSubjects.toSubject(s.getUid(), s.getGid());
        }
        return this.pushExportIndex(parent, this._inner.link(parent, link, path, effectiveSubject));
    }

    @Override
    public DirectoryStream list(Inode inode, byte[] verifier, long cookie) throws IOException {
        Subject effectiveSubject = this.checkAccess(inode, 1);
        if (inode.isPseudoInode()) {
            return new DirectoryStream(this.listPseudoDirectory(inode)).tail(cookie);
        }
        DirectoryStream innerStrem = this._inner.list(inode, verifier, cookie);
        return innerStrem.transform(new PushParentIndex(inode));
    }

    @Override
    public Inode mkdir(Inode parent, String path, Subject subject, int mode) throws IOException {
        Subject effectiveSubject = this.checkAccess(parent, 4);
        if (subject != null && UnixSubjects.isRootSubject(effectiveSubject)) {
            effectiveSubject = subject;
        }
        if (this.inheritUidGid(parent)) {
            Stat s = this._inner.getattr(parent);
            effectiveSubject = UnixSubjects.toSubject(s.getUid(), s.getGid());
        }
        return this.pushExportIndex(parent, this._inner.mkdir(parent, path, effectiveSubject, mode));
    }

    @Override
    public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        this.checkAccess(src, 64);
        this.checkAccess(dest, 66);
        return this._inner.move(src, oldName, dest, newName);
    }

    @Override
    public Inode parentOf(Inode inode) throws IOException {
        Inode parent = this._inner.parentOf(inode);
        Inode asPseudo = this.realToPseudo(parent);
        if (this.isPseudoDirectory(asPseudo)) {
            return asPseudo;
        }
        return this.pushExportIndex(inode, parent);
    }

    @Override
    public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
        this.checkAccess(inode, 1);
        return this._inner.read(inode, data, offset, count);
    }

    @Override
    public int read(Inode inode, ByteBuffer data, long offset) throws IOException {
        this.checkAccess(inode, 1);
        return this._inner.read(inode, data, offset);
    }

    @Override
    public String readlink(Inode inode) throws IOException {
        this.checkAccess(inode, 1);
        return this._inner.readlink(inode);
    }

    @Override
    public void remove(Inode parent, String path) throws IOException {
        try {
            this.checkAccess(parent, 64);
        }
        catch (ChimeraNFSException e) {
            if (e.getStatus() == 13) {
                Inode inode = this.pushExportIndex(parent, this._inner.lookup(parent, path));
                this.checkAccess(inode, 65536);
            }
            throw e;
        }
        this._inner.remove(parent, path);
    }

    @Override
    public Inode symlink(Inode parent, String path, String link, Subject subject, int mode) throws IOException {
        Subject effectiveSubject = this.checkAccess(parent, 2);
        if (this.inheritUidGid(parent)) {
            Stat s = this._inner.getattr(parent);
            effectiveSubject = UnixSubjects.toSubject(s.getUid(), s.getGid());
        }
        return this.pushExportIndex(parent, this._inner.symlink(parent, path, link, effectiveSubject, mode));
    }

    @Override
    public VirtualFileSystem.WriteResult write(Inode inode, byte[] data, long offset, int count, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        this.checkAccess(inode, 2);
        return this._inner.write(inode, data, offset, count, stabilityLevel);
    }

    @Override
    public VirtualFileSystem.WriteResult write(Inode inode, ByteBuffer data, long offset, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        this.checkAccess(inode, 2);
        return this._inner.write(inode, data, offset, stabilityLevel);
    }

    @Override
    public Stat getattr(Inode inode) throws IOException {
        return this._inner.getattr(inode);
    }

    @Override
    public void setattr(Inode inode, Stat stat) throws IOException {
        int mask = 256;
        if (stat.isDefined(Stat.StatAttribute.OWNER)) {
            int currentOwner = this.getattr(inode).getUid();
            if (currentOwner == stat.getUid() || stat.getUid() == -1) {
                stat.undefine(Stat.StatAttribute.OWNER);
            } else {
                mask |= 0x80000;
            }
        }
        if (stat.isDefined(Stat.StatAttribute.SIZE)) {
            mask |= 6;
        }
        this.checkAccess(inode, mask);
        this._inner.setattr(inode, stat);
    }

    @Override
    public nfsace4[] getAcl(Inode inode) throws IOException {
        return this._inner.getAcl(inode);
    }

    @Override
    public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
        this.checkAccess(inode, 262144);
        this._inner.setAcl(inode, acl);
    }

    @Override
    public byte[] getXattr(Inode inode, String attr) throws IOException {
        this.checkAccess(inode, 1);
        return this._inner.getXattr(inode, attr);
    }

    @Override
    public void setXattr(Inode inode, String attr, byte[] value, VirtualFileSystem.SetXattrMode mode) throws IOException {
        this.checkAccess(inode, 2);
        this._inner.setXattr(inode, attr, value, mode);
    }

    @Override
    public String[] listXattrs(Inode inode) throws IOException {
        this.checkAccess(inode, 1);
        return this._inner.listXattrs(inode);
    }

    @Override
    public void removeXattr(Inode inode, String attr) throws IOException {
        this.checkAccess(inode, 2);
        this._inner.removeXattr(inode, attr);
    }

    private Subject checkAccess(Inode inode, int requestedMask) throws IOException {
        return this.checkAccess(inode, requestedMask, true);
    }

    private Subject checkAccess(Inode inode, int requestedMask, boolean shouldLog) throws IOException {
        return this.checkAccess(inode, this._inner.getattr(inode), requestedMask, shouldLog);
    }

    private Subject checkAccess(Inode inode, Stat stat, int requestedMask, boolean shouldLog) throws IOException {
        int unixAccessmask;
        Subject effectiveSubject = this._subject;
        AclCheckable.Access aclMatched = AclCheckable.Access.UNDEFINED;
        if (inode.isPseudoInode() && Acls.wantModify(requestedMask)) {
            if (shouldLog) {
                _log.warn("Access denied: pseudo Inode {} {} {} {}", new Object[]{inode, this._inetAddress, acemask4.toString(requestedMask), new SubjectHolder(effectiveSubject)});
            }
            throw new RoFsException("attempt to modify pseudofs");
        }
        if (!inode.isPseudoInode()) {
            int exportIdx = this.getExportIndex(inode);
            FsExport export = this._exportTable.getExport(exportIdx, this._inetAddress.getAddress());
            if (exportIdx != 0 && export == null) {
                if (shouldLog) {
                    _log.warn("Access denied: (no export) to inode {} for client {}", (Object)inode, (Object)this._inetAddress);
                }
                throw new AccessException("permission deny");
            }
            if (export.isPrivilegedClientPortRequired() && this._inetAddress.getPort() > 1023) {
                if (shouldLog) {
                    _log.warn("Access denied: unprivileged client {}", (Object)this._inetAddress);
                }
                throw new AccessException("unprivileged client");
            }
            PseudoFs.checkSecurityFlavor(this._auth, export.getSec());
            if (export.ioMode() == FsExport.IO.RO && Acls.wantModify(requestedMask)) {
                if (shouldLog) {
                    _log.warn("Access denied: (RO export) inode {} for client {}", (Object)inode, (Object)this._inetAddress);
                }
                throw new AccessException("read-only export");
            }
            if (export.isAllRoot()) {
                _log.debug("permission check to inode {} skipped due to all_root option for client {}", (Object)inode, (Object)this._inetAddress);
                return effectiveSubject;
            }
            if (UnixSubjects.isNobodySubject(this._subject) || export.hasAllSquash() || !export.isTrusted() && UnixSubjects.isRootSubject(this._subject)) {
                effectiveSubject = UnixSubjects.toSubject(export.getAnonUid(), export.getAnonGid());
            }
            if (export.checkAcls() && (aclMatched = this._inner.getAclCheckable().checkAcl(this._subject, inode, requestedMask)) == AclCheckable.Access.DENY) {
                if (shouldLog) {
                    _log.warn("Access deny: {} {} {}", new Object[]{this._inetAddress, acemask4.toString(requestedMask), new SubjectHolder(this._subject)});
                }
                throw new AccessException();
            }
        }
        if (aclMatched == AclCheckable.Access.UNDEFINED && requestedMask != 128 && ((unixAccessmask = this.unixToAccessmask(effectiveSubject, stat)) & requestedMask) != requestedMask) {
            if (shouldLog) {
                _log.warn("Access denied: {} {} {} {} {}", new Object[]{inode, this._inetAddress, acemask4.toString(requestedMask), acemask4.toString(unixAccessmask), new SubjectHolder(this._subject)});
            }
            throw new AccessException("permission deny");
        }
        return effectiveSubject;
    }

    private int unixToAccessmask(Subject subject, Stat stat) {
        int fromUnixMask;
        boolean isDir;
        int mode = stat.getMode();
        boolean bl = isDir = (mode & 0x4000) == 16384;
        if (UnixSubjects.isRootSubject(subject)) {
            fromUnixMask = Acls.toAccessMask(7, isDir, true);
            fromUnixMask |= 0x80000;
        } else {
            fromUnixMask = UnixSubjects.hasUid(subject, stat.getUid()) ? Acls.toAccessMask(mode >> 6, isDir, true) : (UnixSubjects.hasGid(subject, stat.getGid()) ? Acls.toAccessMask(mode >> 3, isDir, false) : Acls.toAccessMask(mode >> 0, isDir, false));
        }
        return fromUnixMask;
    }

    private Inode lookupInPseudoDirectory(Inode parent, String name2) throws IOException {
        Set<PseudoFsNode> nodes = this.prepareExportTree();
        for (PseudoFsNode node : nodes) {
            PseudoFsNode n;
            if (!node.id().equals(parent) || (n = node.getChild(name2)) == null) continue;
            return n.isMountPoint() ? PseudoFs.pseudoIdToReal(n.id(), this.getIndexId(n)) : n.id();
        }
        throw new NoEntException();
    }

    private boolean isPseudoDirectory(Inode dir) throws IOException {
        return this.prepareExportTree().stream().anyMatch(n -> n.id().equals(dir));
    }

    public static Inode pseudoIdToReal(Inode inode, int index) {
        FileHandle fh = new FileHandle.FileHandleBuilder().setExportIdx(index).setType(0).build(inode.getFileId());
        return new Inode(fh);
    }

    private int getIndexId(PseudoFsNode node) {
        List<FsExport> exports2 = node.getExports();
        return exports2.get(0).getIndex();
    }

    private Collection<DirectoryEntry> listPseudoDirectory(Inode parent) throws ChimeraNFSException, IOException {
        Set<PseudoFsNode> nodes = this.prepareExportTree();
        for (PseudoFsNode node : nodes) {
            if (!node.id().equals(parent)) continue;
            if (node.isMountPoint()) {
                return Lists.newArrayList((Iterable)this._inner.list(parent, null, 0L).transform(new ConvertToRealInode(node)));
            }
            long cookie = 3L;
            ArrayList<DirectoryEntry> pseudoLs = new ArrayList<DirectoryEntry>();
            for (String s : node.getChildren()) {
                PseudoFsNode subNode = node.getChild(s);
                Inode inode = subNode.id();
                Stat stat = this._inner.getattr(inode);
                DirectoryEntry e = new DirectoryEntry(s, subNode.isMountPoint() ? PseudoFs.pseudoIdToReal(inode, this.getIndexId(subNode)) : inode, stat, cookie);
                pseudoLs.add(e);
                ++cookie;
            }
            return pseudoLs;
        }
        throw new NoEntException();
    }

    private Inode pushExportIndex(Inode inode, int index) {
        FileHandle fh = new FileHandle.FileHandleBuilder().setExportIdx(index).setType(0).build(inode.getFileId());
        return new Inode(fh);
    }

    private Inode pushExportIndex(Inode parent, Inode inode) {
        return this.pushExportIndex(inode, this.getExportIndex(parent));
    }

    private int getExportIndex(Inode inode) {
        if (inode.handleVersion() == 0) {
            FsExport export = this._exportTable.exports(this._inetAddress.getAddress()).findFirst().orElse(null);
            return export == null ? -1 : export.getIndex();
        }
        return inode.exportIndex();
    }

    private Inode realToPseudo(Inode inode) {
        return this.realToPseudo(inode, 0);
    }

    private Inode realToPseudo(Inode inode, int idx) {
        FileHandle fh = new FileHandle.FileHandleBuilder().setExportIdx(idx).setType(1).build(inode.getFileId());
        return new Inode(fh);
    }

    private void pathToPseudoFs(PseudoFsNode root, Set<PseudoFsNode> all, FsExport e) {
        PseudoFsNode parent = root;
        String path = e.getPath();
        if (e.getPath().equals("/")) {
            root.addExport(e);
            return;
        }
        Splitter splitter = Splitter.on((char)'/').omitEmptyStrings();
        HashSet<PseudoFsNode> pathNodes = new HashSet<PseudoFsNode>();
        for (String s : splitter.split((CharSequence)path)) {
            try {
                PseudoFsNode node = parent.getChild(s);
                if (node == null) {
                    node = new PseudoFsNode(this.realToPseudo(this._inner.lookup(parent.id(), s)));
                    parent.addChild(s, node);
                    pathNodes.add(node);
                }
                parent = node;
            }
            catch (IOException ef) {
                return;
            }
        }
        all.addAll(pathNodes);
        parent.setId(PseudoFs.pseudoIdToReal(parent.id(), e.getIndex()));
        parent.addExport(e);
    }

    private Set<PseudoFsNode> prepareExportTree() throws ChimeraNFSException, IOException {
        HashSet<PseudoFsNode> nodes = new HashSet<PseudoFsNode>();
        Inode rootInode = this.realToPseudo(this._inner.getRootInode());
        PseudoFsNode root = new PseudoFsNode(rootInode);
        this._exportTable.exports(this._inetAddress.getAddress()).forEach(e -> this.pathToPseudoFs(root, (Set<PseudoFsNode>)nodes, (FsExport)e));
        if (nodes.isEmpty()) {
            _log.warn("No exports found for: {}", (Object)this._inetAddress);
            throw new AccessException();
        }
        nodes.add(root);
        return nodes;
    }

    private static void checkSecurityFlavor(RpcAuth auth, FsExport.Sec minFlavor) throws ChimeraNFSException {
        FsExport.Sec usedFlavor;
        block0 : switch (auth.type()) {
            case 0: {
                usedFlavor = FsExport.Sec.NONE;
                break;
            }
            case 1: {
                usedFlavor = FsExport.Sec.SYS;
                break;
            }
            case 6: {
                RpcAuthGss authGss = (RpcAuthGss)auth;
                switch (authGss.getService()) {
                    case 1: {
                        usedFlavor = FsExport.Sec.KRB5;
                        break block0;
                    }
                    case 2: {
                        usedFlavor = FsExport.Sec.KRB5I;
                        break block0;
                    }
                    case 3: {
                        usedFlavor = FsExport.Sec.KRB5P;
                        break block0;
                    }
                }
                throw new PermException("Unsupported Authentication GSS service: " + authGss.getService());
            }
            default: {
                throw new PermException("Unsupported Authentication flavor: " + auth.type());
            }
        }
        if (usedFlavor.compareTo(minFlavor) < 0) {
            throw new PermException("Authentication flavor too weak: allowed <" + minFlavor + "> provided <" + usedFlavor + ">");
        }
    }

    private boolean inheritUidGid(Inode inode) {
        return this._exportTable.getExport(inode.exportIndex(), this._inetAddress.getAddress()).isAllRoot();
    }

    private class PushParentIndex
    implements Function<DirectoryEntry, DirectoryEntry> {
        private final Inode _inode;

        PushParentIndex(Inode parent) {
            this._inode = parent;
        }

        @Override
        public DirectoryEntry apply(DirectoryEntry input) {
            return new DirectoryEntry(input.getName(), PseudoFs.this.pushExportIndex(this._inode, input.getInode()), input.getStat(), input.getCookie());
        }
    }

    private class ConvertToRealInode
    implements Function<DirectoryEntry, DirectoryEntry> {
        private final PseudoFsNode _node;

        ConvertToRealInode(PseudoFsNode node) {
            this._node = node;
        }

        @Override
        public DirectoryEntry apply(DirectoryEntry input) {
            return new DirectoryEntry(input.getName(), PseudoFs.pseudoIdToReal(input.getInode(), PseudoFs.this.getIndexId(this._node)), input.getStat(), input.getCookie());
        }
    }
}

