/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.vfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.security.auth.Subject;
import org.dcache.nfs.v4.NfsIdMapping;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.vfs.AclCheckable;
import org.dcache.nfs.vfs.DirectoryStream;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;

public abstract class ForwardingFileSystem
implements VirtualFileSystem {
    protected abstract VirtualFileSystem delegate();

    @Override
    public int access(Subject subject, Inode inode, int mode) throws IOException {
        return this.delegate().access(subject, inode, mode);
    }

    @Override
    public Inode create(Inode parent, Stat.Type type, String path, Subject subject, int mode) throws IOException {
        return this.delegate().create(parent, type, path, subject, mode);
    }

    @Override
    public FsStat getFsStat() throws IOException {
        return this.delegate().getFsStat();
    }

    @Override
    public Inode getRootInode() throws IOException {
        return this.delegate().getRootInode();
    }

    @Override
    public Inode lookup(Inode parent, String path) throws IOException {
        return this.delegate().lookup(parent, path);
    }

    @Override
    public Inode link(Inode parent, Inode link, String path, Subject subject) throws IOException {
        return this.delegate().link(parent, link, path, subject);
    }

    @Override
    public DirectoryStream list(Inode inode, byte[] verifier, long cookie) throws IOException {
        return this.delegate().list(inode, verifier, cookie);
    }

    @Override
    public Inode mkdir(Inode parent, String path, Subject subject, int mode) throws IOException {
        return this.delegate().mkdir(parent, path, subject, mode);
    }

    @Override
    public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        return this.delegate().move(src, oldName, dest, newName);
    }

    @Override
    public Inode parentOf(Inode inode) throws IOException {
        return this.delegate().parentOf(inode);
    }

    @Override
    public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
        return this.delegate().read(inode, data, offset, count);
    }

    @Override
    public int read(Inode inode, ByteBuffer data, long offset) throws IOException {
        return this.delegate().read(inode, data, offset);
    }

    @Override
    public String readlink(Inode inode) throws IOException {
        return this.delegate().readlink(inode);
    }

    @Override
    public void remove(Inode parent, String path) throws IOException {
        this.delegate().remove(parent, path);
    }

    @Override
    public Inode symlink(Inode parent, String path, String link, Subject subject, int mode) throws IOException {
        return this.delegate().symlink(parent, path, link, subject, mode);
    }

    @Override
    public VirtualFileSystem.WriteResult write(Inode inode, byte[] data, long offset, int count, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        return this.delegate().write(inode, data, offset, count, stabilityLevel);
    }

    @Override
    public VirtualFileSystem.WriteResult write(Inode inode, ByteBuffer data, long offset, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        return this.delegate().write(inode, data, offset, stabilityLevel);
    }

    @Override
    public void commit(Inode inode, long offset, int count) throws IOException {
        this.delegate().commit(inode, offset, count);
    }

    @Override
    public Stat getattr(Inode inode) throws IOException {
        return this.delegate().getattr(inode);
    }

    @Override
    public void setattr(Inode inode, Stat stat) throws IOException {
        this.delegate().setattr(inode, stat);
    }

    @Override
    public nfsace4[] getAcl(Inode inode) throws IOException {
        return this.delegate().getAcl(inode);
    }

    @Override
    public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
        this.delegate().setAcl(inode, acl);
    }

    @Override
    public boolean getCaseInsensitive() {
        return this.delegate().getCaseInsensitive();
    }

    @Override
    public boolean getCasePreserving() {
        return this.delegate().getCasePreserving();
    }

    @Override
    public boolean hasIOLayout(Inode inode) throws IOException {
        return this.delegate().hasIOLayout(inode);
    }

    @Override
    public AclCheckable getAclCheckable() {
        return this.delegate().getAclCheckable();
    }

    @Override
    public NfsIdMapping getIdMapper() {
        return this.delegate().getIdMapper();
    }

    @Override
    public byte[] directoryVerifier(Inode inode) throws IOException {
        return this.delegate().directoryVerifier(inode);
    }

    @Override
    public byte[] getXattr(Inode inode, String attr) throws IOException {
        return this.delegate().getXattr(inode, attr);
    }

    @Override
    public void setXattr(Inode inode, String attr, byte[] value, VirtualFileSystem.SetXattrMode mode) throws IOException {
        this.delegate().setXattr(inode, attr, value, mode);
    }

    @Override
    public String[] listXattrs(Inode inode) throws IOException {
        return this.delegate().listXattrs(inode);
    }

    @Override
    public void removeXattr(Inode inode, String attr) throws IOException {
        this.delegate().removeXattr(inode, attr);
    }
}

