/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.vfs;

import com.google.common.collect.ForwardingNavigableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.dcache.nfs.vfs.DirectoryEntry;

public class DirectoryStream
implements Iterable<DirectoryEntry> {
    public static final byte[] ZERO_VERIFIER = new byte[8];
    private final byte[] verifier;
    private final NavigableSet<DirectoryEntry> entries;

    public DirectoryStream(Collection<DirectoryEntry> entries) {
        this(ZERO_VERIFIER, (NavigableSet<DirectoryEntry>)new TreeSet<DirectoryEntry>(entries));
    }

    public DirectoryStream(byte[] verifier, Collection<DirectoryEntry> entries) {
        this(verifier, (NavigableSet<DirectoryEntry>)new TreeSet<DirectoryEntry>(entries));
    }

    public DirectoryStream(byte[] verifier, NavigableSet<DirectoryEntry> entries) {
        this.verifier = verifier;
        this.entries = Collections.unmodifiableNavigableSet(entries);
    }

    public byte[] getVerifier() {
        return this.verifier;
    }

    @Override
    public Iterator<DirectoryEntry> iterator() {
        return this.entries.iterator();
    }

    public DirectoryStream tail(long fromCookie) {
        DirectoryEntry cookieEntry = new DirectoryEntry("", null, null, fromCookie);
        return new DirectoryStream(this.verifier, this.entries.tailSet(cookieEntry, false));
    }

    public DirectoryStream transform(Function<? super DirectoryEntry, DirectoryEntry> function) {
        return new DirectoryStream(this.verifier, (NavigableSet<DirectoryEntry>)((Object)new TransformingNavigableSet(function, this.entries)));
    }

    private static class TransformingNavigableSet
    extends ForwardingNavigableSet<DirectoryEntry> {
        private final Function<? super DirectoryEntry, DirectoryEntry> transformation;
        private final NavigableSet<DirectoryEntry> inner;

        public TransformingNavigableSet(Function<? super DirectoryEntry, DirectoryEntry> transformation, NavigableSet<DirectoryEntry> inner) {
            this.transformation = transformation;
            this.inner = inner;
        }

        protected NavigableSet<DirectoryEntry> delegate() {
            return this.inner;
        }

        public Iterator<DirectoryEntry> iterator() {
            return new TransformingIterator(this.transformation, this.delegate().iterator());
        }

        public NavigableSet<DirectoryEntry> tailSet(DirectoryEntry fromElement, boolean inclusive) {
            return new TransformingNavigableSet(this.transformation, super.tailSet((Object)fromElement, inclusive));
        }
    }

    private static class TransformingIterator
    implements Iterator<DirectoryEntry> {
        private final Function<? super DirectoryEntry, DirectoryEntry> transformation;
        private final Iterator<DirectoryEntry> inner;

        public TransformingIterator(Function<? super DirectoryEntry, DirectoryEntry> transformation, Iterator<DirectoryEntry> inner) {
            this.transformation = transformation;
            this.inner = inner;
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public DirectoryEntry next() {
            return this.transformation.apply(this.inner.next());
        }
    }
}

