/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.xdr;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.dcache.oncrpc4j.xdr.XdrDecodingStream;
import org.dcache.oncrpc4j.xdr.XdrEncodingStream;

public class bitmap4
implements XdrAble,
Iterable<Integer> {
    public int[] value;

    public bitmap4() {
        this(new int[]{0, 0});
    }

    public bitmap4(int[] value) {
        this.value = value;
    }

    public bitmap4(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this.xdrDecode(xdr);
    }

    public void xdrEncode(XdrEncodingStream xdr) throws OncRpcException, IOException {
        int $size = this.value.length;
        xdr.xdrEncodeInt($size);
        for (int $idx = 0; $idx < $size; ++$idx) {
            xdr.xdrEncodeInt(this.value[$idx]);
        }
    }

    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        int $size = xdr.xdrDecodeInt();
        this.value = new int[$size];
        for (int $idx = 0; $idx < $size; ++$idx) {
            this.value[$idx] = xdr.xdrDecodeInt();
        }
    }

    public static bitmap4 of(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("No values provided");
        }
        int max = values[0];
        for (int v : values) {
            if (v <= max) continue;
            max = v;
        }
        int n = max / 32 + 1;
        bitmap4 bitmap = new bitmap4(new int[n]);
        for (int v : values) {
            int bit = v % 32;
            int n2 = v / 32;
            bitmap.value[n2] = bitmap.value[n2] | 1 << bit;
        }
        return bitmap;
    }

    public void set(int bit) {
        this.ensureCapacity(bit);
        int n = bit / 32;
        this.value[n] = this.value[n] | 1 << bit % 32;
    }

    public boolean isSet(int bit) {
        int bitmapIdx = bit / 32;
        if (this.value == null || bitmapIdx + 1 > this.value.length) {
            return false;
        }
        return (this.value[bitmapIdx] >> bit % 32 & 1) > 0;
    }

    private void ensureCapacity(int bit) {
        int expected = bit / 32 + 1;
        if (this.value == null || this.value.length < expected) {
            int[] newBitmap = new int[expected];
            if (this.value != null) {
                System.arraycopy(this.value, 0, newBitmap, 0, this.value.length);
            }
            this.value = newBitmap;
        }
    }

    public boolean isEmpty() {
        if (this.value == null) {
            return true;
        }
        for (int mask : this.value) {
            if (mask == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int currentIndex = -1;

            @Override
            public boolean hasNext() {
                if (bitmap4.this.value == null || this.currentIndex > bitmap4.this.value.length * 32) {
                    return false;
                }
                ++this.currentIndex;
                while (this.currentIndex < bitmap4.this.value.length * 32) {
                    int bitmapIdx = this.currentIndex / 32;
                    int bit = bitmap4.this.value[bitmapIdx] >> this.currentIndex % 32 & 1;
                    if (bit != 0) {
                        return true;
                    }
                    ++this.currentIndex;
                }
                return false;
            }

            @Override
            public Integer next() {
                this.checkPosition();
                return this.currentIndex;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void checkPosition() {
                if (bitmap4.this.value == null || this.currentIndex < 0 || this.currentIndex > bitmap4.this.value.length * 32) {
                    throw new NoSuchElementException();
                }
            }
        };
    }

    public int hashCode() {
        int hash = 1;
        if (this.value != null) {
            int n;
            for (n = this.value.length; n > 0 && this.value[n - 1] == 0; --n) {
            }
            for (int i = 0; i < n; ++i) {
                hash = 31 * hash + this.value[i];
            }
        }
        return hash;
    }

    public boolean equals(Object obj) {
        int k;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        bitmap4 other = (bitmap4)obj;
        int len = 0;
        int olen = 0;
        if (this.value != null) {
            len = this.value.length;
        }
        if (other.value != null) {
            olen = other.value.length;
        }
        int match = Math.min(len, olen);
        for (int i = 0; i < match; ++i) {
            if (this.value[i] == other.value[i]) continue;
            return false;
        }
        for (k = i; k < len; ++k) {
            if (this.value[k] == 0) continue;
            return false;
        }
        for (k = i; k < olen; ++k) {
            if (other.value[k] == 0) continue;
            return false;
        }
        return true;
    }
}

