/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.nlm;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import org.dcache.nfs.v4.StateOwner;
import org.dcache.nfs.v4.xdr.nfs_lock_type4;

public class NlmLock
implements Serializable {
    private static final long serialVersionUID = -839338915510175006L;
    private final StateOwner owner;
    private final long offset;
    private final long length;
    private final int lockType;

    public NlmLock(StateOwner owner, int lockType, long offset, long length) {
        this.owner = owner;
        this.offset = offset;
        this.length = length;
        this.lockType = lockType;
    }

    public StateOwner getOwner() {
        return this.owner;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public int getLockType() {
        return this.lockType;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + this.owner.hashCode();
        hash = 23 * hash + (int)(this.offset ^ this.offset >>> 32);
        hash = 23 * hash + (int)(this.length ^ this.length >>> 32);
        hash = 23 * hash + (this.lockType ^ this.lockType >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NlmLock other = (NlmLock)obj;
        if (this.offset != other.offset) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.lockType != other.lockType) {
            return false;
        }
        return this.owner.equals(other.owner);
    }

    public boolean isSameOwner(NlmLock other) {
        return this.owner.equals(other.owner);
    }

    public boolean isOverlappingRange(NlmLock other) {
        if (other.length == -1L && this.length == -1L) {
            return true;
        }
        if (other.length == -1L) {
            return this.offset > other.offset || other.offset - this.length < this.offset;
        }
        if (this.length == -1L) {
            return other.offset > this.offset || this.offset - other.length < other.offset;
        }
        if (this.offset > other.offset) {
            return this.offset - other.offset < other.length;
        }
        if (other.offset > this.offset) {
            return other.offset - this.offset < this.length;
        }
        return true;
    }

    public boolean isConflictingType(NlmLock other) {
        return this.lockType == 2 || this.lockType == 4 || other.lockType == 2 || other.lockType == 4;
    }

    public boolean isConflicting(NlmLock other) {
        return this.isOverlappingRange(other) && !this.isSameOwner(other) && this.isConflictingType(other);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Lock").add("offset", this.offset).add("length", this.length).add("owner", (Object)this.owner).add("lock_type", (Object)nfs_lock_type4.toString(this.lockType)).toString();
    }
}

