/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.nlm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.dcache.nfs.v4.nlm.LockDeniedException;
import org.dcache.nfs.v4.nlm.LockException;
import org.dcache.nfs.v4.nlm.LockManager;
import org.dcache.nfs.v4.nlm.LockRangeUnavailabeException;
import org.dcache.nfs.v4.nlm.NlmLock;

public abstract class AbstractLockManager
implements LockManager {
    protected abstract Lock getObjectLock(byte[] var1);

    protected abstract Collection<NlmLock> getActiveLocks(byte[] var1);

    protected abstract void add(byte[] var1, NlmLock var2);

    protected abstract boolean remove(byte[] var1, NlmLock var2);

    protected abstract void addAll(byte[] var1, Collection<NlmLock> var2);

    protected abstract void removeAll(byte[] var1, Collection<NlmLock> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(byte[] objId, NlmLock lock) throws LockException {
        Lock dlmLock = this.getObjectLock(objId);
        dlmLock.lock();
        try {
            Collection<NlmLock> currentLocks = this.getActiveLocks(objId);
            Optional<NlmLock> conflictingLock = currentLocks.stream().filter(l -> l.isConflicting(lock)).findAny();
            if (conflictingLock.isPresent()) {
                throw new LockDeniedException("object locked", conflictingLock.get());
            }
            List<NlmLock> toMerge = currentLocks.stream().filter(l -> l.isOverlappingRange(lock)).filter(l -> l.isSameOwner(lock)).filter(l -> l.getLockType() == lock.getLockType()).collect(Collectors.toList());
            if (toMerge.isEmpty()) {
                this.add(objId, lock);
            } else {
                long lockBegin = lock.getOffset();
                long lockEnd = lock.getLength() == -1L ? -1L : lockBegin + lock.getLength();
                for (NlmLock l2 : toMerge) {
                    lockBegin = Math.min(lockBegin, l2.getOffset());
                    lockEnd = lockEnd == -1L || l2.getLength() == -1L ? -1L : Math.max(lockEnd, l2.getOffset() + l2.getLength() - 1L);
                }
                NlmLock mergedLock = new NlmLock(lock.getOwner(), lock.getLockType(), lockBegin, lockEnd == -1L ? lockEnd : lockEnd - lockBegin);
                this.removeAll(objId, toMerge);
                this.add(objId, mergedLock);
            }
        }
        finally {
            dlmLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(byte[] objId, NlmLock lock) throws LockException {
        Lock dlmLock = this.getObjectLock(objId);
        dlmLock.lock();
        try {
            Collection<NlmLock> currentLocks = this.getActiveLocks(objId);
            if (this.remove(objId, lock)) {
                return;
            }
            ArrayList<NlmLock> toRemove = new ArrayList<NlmLock>();
            ArrayList<NlmLock> toAdd = new ArrayList<NlmLock>();
            currentLocks.stream().filter(l -> l.isSameOwner(lock)).filter(l -> l.isOverlappingRange(lock)).forEach(l -> {
                long l2;
                toRemove.add((NlmLock)l);
                long l1 = lock.getOffset() - l.getOffset();
                if (l1 > 0L) {
                    NlmLock first = new NlmLock(l.getOwner(), l.getLockType(), l.getOffset(), l1);
                    toAdd.add(first);
                }
                if (lock.getLength() != -1L && (l2 = l.getLength() - l1 - 1L) > 0L) {
                    NlmLock second = new NlmLock(l.getOwner(), l.getLockType(), lock.getOffset() + lock.getLength(), l2);
                    toAdd.add(second);
                }
            });
            if (toRemove.isEmpty()) {
                throw new LockRangeUnavailabeException("no matching lock");
            }
            this.removeAll(objId, toRemove);
            this.addAll(objId, toAdd);
        }
        finally {
            dlmLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void test(byte[] objId, NlmLock lock) throws LockException {
        Lock dlmLock = this.getObjectLock(objId);
        dlmLock.lock();
        try {
            Collection<NlmLock> currentLocks = this.getActiveLocks(objId);
            Optional<NlmLock> conflictingLock = currentLocks.stream().filter(l -> l.isOverlappingRange(lock) && !l.isSameOwner(lock)).findAny();
            if (conflictingLock.isPresent()) {
                throw new LockDeniedException("object locked", conflictingLock.get());
            }
        }
        finally {
            dlmLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockIfExists(byte[] objId, NlmLock lock) {
        Lock dlmLock = this.getObjectLock(objId);
        dlmLock.lock();
        try {
            this.remove(objId, lock);
        }
        finally {
            dlmLock.unlock();
        }
    }
}

