/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.ds;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.IsDirException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.xdr.READ4res;
import org.dcache.nfs.v4.xdr.READ4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.FsCache;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSOperationREAD
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(DSOperationREAD.class);
    private final FsCache _fsCache;

    public DSOperationREAD(nfs_argop4 args, FsCache fsCache) {
        super(args, 25);
        this._fsCache = fsCache;
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        READ4res res = result.opread;
        Inode inode = context.currentInode();
        Stat stat = context.getFs().getattr(inode);
        if (stat.type() == Stat.Type.DIRECTORY) {
            throw new IsDirException("Can't READ a directory inode");
        }
        if (stat.type() != Stat.Type.REGULAR) {
            throw new InvalException("Invalid object type");
        }
        if (context.getMinorversion() == 0 && !Stateids.ZeroStateId().equalsWithSeq(this._args.opread.stateid) && !Stateids.OneStateId().equalsWithSeq(this._args.opread.stateid)) {
            context.getStateHandler().updateClientLeaseTime(this._args.opread.stateid);
        }
        boolean eof = false;
        long offset = this._args.opread.offset.value;
        int count = this._args.opread.count.value;
        ByteBuffer bb = ByteBuffer.allocateDirect(count);
        FileChannel in = this._fsCache.get(inode);
        int bytesReaded = in.read(bb, offset);
        if (bytesReaded < 0) {
            eof = true;
            bytesReaded = 0;
        }
        res.status = 0;
        res.resok4 = new READ4resok();
        bb.flip();
        res.resok4.data = bb;
        if (offset + (long)bytesReaded == stat.getSize()) {
            eof = true;
        }
        res.resok4.eof = eof;
        _log.debug("MOVER: {}@{} readed, {} requested.", new Object[]{bytesReaded, offset, this._args.opread.count.value});
    }
}

