/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.ds;

import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.AbstractOperationExecutor;
import org.dcache.nfs.v4.OperationBIND_CONN_TO_SESSION;
import org.dcache.nfs.v4.OperationCREATE_SESSION;
import org.dcache.nfs.v4.OperationDESTROY_CLIENTID;
import org.dcache.nfs.v4.OperationDESTROY_SESSION;
import org.dcache.nfs.v4.OperationEXCHANGE_ID;
import org.dcache.nfs.v4.OperationGETATTR;
import org.dcache.nfs.v4.OperationILLEGAL;
import org.dcache.nfs.v4.OperationPUTFH;
import org.dcache.nfs.v4.OperationPUTROOTFH;
import org.dcache.nfs.v4.OperationRECLAIM_COMPLETE;
import org.dcache.nfs.v4.OperationSEQUENCE;
import org.dcache.nfs.v4.ds.DSOperationCOMMIT;
import org.dcache.nfs.v4.ds.DSOperationREAD;
import org.dcache.nfs.v4.ds.DSOperationWRITE;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.vfs.FsCache;

public class DSOperationExecutor
extends AbstractOperationExecutor {
    private final FsCache _fs;

    public DSOperationExecutor(FsCache fs) {
        this._fs = fs;
    }

    @Override
    protected AbstractNFSv4Operation getOperation(nfs_argop4 op) {
        switch (op.argop) {
            case 5: {
                return new DSOperationCOMMIT(op, this._fs);
            }
            case 9: {
                return new OperationGETATTR(op);
            }
            case 22: {
                return new OperationPUTFH(op);
            }
            case 24: {
                return new OperationPUTROOTFH(op);
            }
            case 25: {
                return new DSOperationREAD(op, this._fs);
            }
            case 38: {
                return new DSOperationWRITE(op, this._fs);
            }
            case 42: {
                return new OperationEXCHANGE_ID(op);
            }
            case 43: {
                return new OperationCREATE_SESSION(op);
            }
            case 44: {
                return new OperationDESTROY_SESSION(op);
            }
            case 53: {
                return new OperationSEQUENCE(op);
            }
            case 58: {
                return new OperationRECLAIM_COMPLETE(op);
            }
            case 41: {
                return new OperationBIND_CONN_TO_SESSION(op);
            }
            case 57: {
                return new OperationDESTROY_CLIENTID(op);
            }
        }
        return new OperationILLEGAL(op);
    }
}

