/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.stateid4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stateids {
    private static final Logger _log = LoggerFactory.getLogger(Stateids.class);
    private static final stateid4 CURRENT_STATEID = new stateid4(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 1);
    private static final stateid4 INVAL_STATEID = new stateid4(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, -1);
    private static final stateid4 ZERO_STATEID = new stateid4(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 0);
    private static final stateid4 ONE_STATEID = new stateid4(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, -1);

    private Stateids() {
    }

    public static stateid4 uptodateOf(stateid4 stateid) {
        return new stateid4(stateid.other, 0);
    }

    public static stateid4 currentStateId() {
        return CURRENT_STATEID;
    }

    public static stateid4 invalidStateId() {
        return INVAL_STATEID;
    }

    public static stateid4 ZeroStateId() {
        return ZERO_STATEID;
    }

    public static stateid4 OneStateId() {
        return ONE_STATEID;
    }

    public static boolean isStateLess(stateid4 stateid) {
        return stateid.equalsWithSeq(ZERO_STATEID) || stateid.equalsWithSeq(ONE_STATEID);
    }

    public static void checkStateId(stateid4 expected, stateid4 stateid) throws ChimeraNFSException {
        if (stateid.seqid == 0) {
            return;
        }
        if (expected.seqid > stateid.seqid) {
            _log.warn("Ignore old stateid: " + stateid + " expected: " + expected);
        }
        if (expected.seqid < stateid.seqid) {
            _log.warn("Ignore bad stateId: " + stateid + " expected: " + expected);
        }
    }

    public static stateid4 getCurrentStateidIfNeeded(CompoundContext context, stateid4 stateid) throws ChimeraNFSException {
        if (stateid.equalsWithSeq(CURRENT_STATEID)) {
            return context.currentStateid();
        }
        return stateid;
    }
}

