/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import org.dcache.nfs.status.BadSeqidException;
import org.dcache.nfs.v4.xdr.seqid4;
import org.dcache.nfs.v4.xdr.state_owner4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateOwner
implements Serializable {
    private static final Logger _log = LoggerFactory.getLogger(StateOwner.class);
    private static final long serialVersionUID = -4712959403595550903L;
    private int seq;
    private final state_owner4 owner;

    public StateOwner(state_owner4 owner, int seq) {
        this.owner = owner;
        this.seq = seq;
    }

    public synchronized void acceptAsNextSequence(seqid4 openSeqid) throws BadSeqidException {
        int next = this.seq + 1;
        if (next != openSeqid.value) {
            _log.error("Expected next sequence id {} but received {}", (Object)next, (Object)openSeqid);
            this.seq = openSeqid.value;
        } else {
            this.seq = next;
        }
    }

    public int hashCode() {
        return this.owner.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateOwner other = (StateOwner)obj;
        return this.owner.equals(other.owner);
    }

    public state_owner4 getRawStateOwner() {
        return this.owner;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("owner", (Object)this.owner).add("seq", this.seq).toString();
    }
}

