/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.xdr.TEST_STATEID4res;
import org.dcache.nfs.v4.xdr.TEST_STATEID4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.oncrpc4j.rpc.OncRpcException;

public class OperationTEST_STATEID
extends AbstractNFSv4Operation {
    public OperationTEST_STATEID(nfs_argop4 args) {
        super(args, 55);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        TEST_STATEID4res res = result.optest_stateid;
        res.tsr_resok4 = new TEST_STATEID4resok();
        res.tsr_resok4.tsr_status_codes = new int[this._args.optest_stateid.ts_stateids.length];
        res.tsr_status = 0;
        NFS4Client client = context.getSession().getClient();
        for (int i = 0; i < this._args.optest_stateid.ts_stateids.length; ++i) {
            stateid4 statid = this._args.optest_stateid.ts_stateids[i];
            try {
                NFS4State state = client.state(statid);
                if (state.stateid().seqid < statid.seqid) {
                    res.tsr_resok4.tsr_status_codes[i] = 10024;
                    continue;
                }
                res.tsr_resok4.tsr_status_codes[i] = 0;
                continue;
            }
            catch (ChimeraNFSException e) {
                res.tsr_resok4.tsr_status_codes[i] = e.getStatus();
            }
        }
    }
}

