/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadXdrException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.change_info4;
import org.dcache.nfs.v4.xdr.changeid4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.oncrpc4j.rpc.OncRpcException;

public class OperationSETXATTR
extends AbstractNFSv4Operation {
    public OperationSETXATTR(nfs_argop4 args) {
        super(args, 73);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        Inode inode = context.currentInode();
        result.opsetxattr.sxr_info = new change_info4();
        result.opsetxattr.sxr_info.atomic = true;
        Stat stat = context.getFs().getattr(inode);
        result.opsetxattr.sxr_info.before = new changeid4(stat.getGeneration());
        context.getFs().setXattr(inode, this._args.opsetxattr.sxa_name, this._args.opsetxattr.sxa_value.value, this.toXatterSetMode(this._args.opsetxattr.sxa_option));
        stat = context.getFs().getattr(inode);
        result.opsetxattr.sxr_info.after = new changeid4(stat.getGeneration());
        result.setStatus(0);
    }

    private final VirtualFileSystem.SetXattrMode toXatterSetMode(int i) throws BadXdrException {
        switch (i) {
            case 0: {
                return VirtualFileSystem.SetXattrMode.EITHER;
            }
            case 1: {
                return VirtualFileSystem.SetXattrMode.CREATE;
            }
            case 2: {
                return VirtualFileSystem.SetXattrMode.REPLACE;
            }
        }
        throw new BadXdrException("Unknown setxattr mode " + i);
    }
}

