/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.AttrNotSuppException;
import org.dcache.nfs.status.BadXdrException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.OpenModeException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.NFSv4FileAttributes;
import org.dcache.nfs.v4.OperationGETATTR;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.acl.Acls;
import org.dcache.nfs.v4.xdr.SETATTR4res;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.fattr4;
import org.dcache.nfs.v4.xdr.fattr4_acl;
import org.dcache.nfs.v4.xdr.mode4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.nfstime4;
import org.dcache.nfs.v4.xdr.settime4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.uint64_t;
import org.dcache.nfs.v4.xdr.utf8str_cs;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.xdr.BadXdrOncRpcException;
import org.dcache.oncrpc4j.xdr.Xdr;
import org.dcache.oncrpc4j.xdr.XdrDecodingStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSETATTR
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationSETATTR.class);

    public OperationSETATTR(nfs_argop4 args) {
        super(args, 34);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        SETATTR4res res = result.opsetattr;
        assert (res.attrsset != null);
        Inode inode = context.currentInode();
        if (this._args.opsetattr.obj_attributes.attrmask.isSet(4) && !Stateids.isStateLess(this._args.opsetattr.stateid)) {
            stateid4 stateid = Stateids.getCurrentStateidIfNeeded(context, this._args.opsetattr.stateid);
            NFS4Client client = context.getMinorversion() > 0 ? context.getSession().getClient() : context.getStateHandler().getClientIdByStateId(stateid);
            NFS4State state = client.state(stateid);
            int shareAccess = context.getStateHandler().getFileTracker().getShareAccess(client, inode, state.getOpenState().stateid());
            if ((shareAccess & 2) == 0) {
                throw new OpenModeException("Invalid open mode");
            }
        }
        res.status = 0;
        res.attrsset = OperationSETATTR.setAttributes(this._args.opsetattr.obj_attributes, inode, context);
    }

    static bitmap4 setAttributes(fattr4 attributes, Inode inode, CompoundContext context) throws IOException, OncRpcException {
        bitmap4 processedAttributes = new bitmap4();
        Stat stat = new Stat();
        try (Xdr xdr = new Xdr(attributes.attr_vals.value);){
            xdr.beginDecoding();
            try {
                for (int i : attributes.attrmask) {
                    OperationSETATTR.xdr2fattr(i, stat, inode, context, (XdrDecodingStream)xdr);
                    _log.debug("   setAttributes : {} ({}) OK", (Object)i, (Object)OperationGETATTR.attrMask2String(i));
                    processedAttributes.set(i);
                }
            }
            catch (BadXdrOncRpcException e) {
                throw new BadXdrException(e.getMessage());
            }
            if (xdr.hasMoreData()) {
                throw new BadXdrException("garbage in attr bitmap");
            }
            xdr.endDecoding();
        }
        context.getFs().setattr(inode, stat);
        return processedAttributes;
    }

    static void xdr2fattr(int fattr, Stat stat, Inode inode, CompoundContext context, XdrDecodingStream xdr) throws IOException, OncRpcException {
        switch (fattr) {
            case 4: {
                uint64_t size = new uint64_t();
                size.xdrDecode(xdr);
                stat.setSize(size.value);
                break;
            }
            case 12: {
                fattr4_acl acl = new fattr4_acl();
                acl.xdrDecode(xdr);
                context.getFs().setAcl(inode, acl.value);
                stat.setMTime(System.currentTimeMillis());
                break;
            }
            case 33: {
                mode4 mode = new mode4();
                mode.xdrDecode(xdr);
                stat.setMode(mode.value);
                context.getFs().setAcl(inode, Acls.adjust(context.getFs().getAcl(inode), mode.value));
                break;
            }
            case 36: {
                utf8str_cs owner = new utf8str_cs();
                owner.xdrDecode(xdr);
                String new_owner = owner.toString();
                if (new_owner.isEmpty()) {
                    throw new InvalException("empty principal");
                }
                stat.setUid(context.getFs().getIdMapper().principalToUid(new_owner));
                break;
            }
            case 37: {
                utf8str_cs owner_group = new utf8str_cs();
                owner_group.xdrDecode(xdr);
                String new_group = owner_group.toString();
                if (new_group.isEmpty()) {
                    throw new InvalException("empty principal");
                }
                stat.setGid(context.getFs().getIdMapper().principalToGid(new_group));
                break;
            }
            case 48: {
                settime4 atime = new settime4();
                atime.xdrDecode(xdr);
                break;
            }
            case 50: {
                nfstime4 ctime = new nfstime4();
                ctime.xdrDecode(xdr);
                stat.setCTime(ctime.toMillis());
                break;
            }
            case 54: {
                settime4 setMtime = new settime4();
                setMtime.xdrDecode(xdr);
                long realMtime = setMtime.set_it == 0 ? System.currentTimeMillis() : setMtime.time.toMillis();
                stat.setMTime(realMtime);
                break;
            }
            default: {
                if (NFSv4FileAttributes.SUPPORTED_ATTR_MASK_V4_1.isSet(fattr)) {
                    throw new InvalException("Read-only attribute: " + fattr);
                }
                throw new AttrNotSuppException("Attribute not supported: " + fattr);
            }
        }
    }
}

