/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NameFilter;
import org.dcache.nfs.v4.xdr.REMOVE4res;
import org.dcache.nfs.v4.xdr.REMOVE4resok;
import org.dcache.nfs.v4.xdr.change_info4;
import org.dcache.nfs.v4.xdr.changeid4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationREMOVE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationREMOVE.class);

    public OperationREMOVE(nfs_argop4 args) {
        super(args, 28);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        REMOVE4res res = result.opremove;
        res.status = 0;
        res.resok4 = new REMOVE4resok();
        res.resok4.cinfo = new change_info4();
        res.resok4.cinfo.atomic = true;
        Inode parentInode = context.currentInode();
        Stat stat = context.getFs().getattr(parentInode);
        if (stat.type() != Stat.Type.DIRECTORY) {
            throw new NotDirException();
        }
        String name2 = NameFilter.convertName(this._args.opremove.target.value);
        _log.debug("REMOVE: {} : {}", (Object)parentInode, (Object)name2);
        res.resok4.cinfo.before = new changeid4(stat.getGeneration());
        context.getFs().remove(parentInode, name2);
        res.resok4.cinfo.after = new changeid4(context.getFs().getattr(parentInode).getGeneration());
    }
}

