/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.READLINK4res;
import org.dcache.nfs.v4.xdr.READLINK4resok;
import org.dcache.nfs.v4.xdr.linktext4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.utf8str_cs;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationREADLINK
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationREADLINK.class);

    public OperationREADLINK(nfs_argop4 args) {
        super(args, 27);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        READLINK4res res = result.opreadlink;
        Stat stat = context.getFs().getattr(context.currentInode());
        if (stat.type() != Stat.Type.SYMLINK) {
            throw new InvalException("not a symlink");
        }
        String link = context.getFs().readlink(context.currentInode());
        _log.debug("NFS Request  READLINK4 link: {}", (Object)link);
        res.resok4 = new READLINK4resok();
        res.resok4.link = new linktext4();
        res.resok4.link.value = new utf8str_cs(link);
        res.status = 0;
    }
}

