/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Iterator;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadCookieException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.status.TooSmallException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.OperationGETATTR;
import org.dcache.nfs.v4.xdr.READDIR4res;
import org.dcache.nfs.v4.xdr.READDIR4resok;
import org.dcache.nfs.v4.xdr.attrlist4;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.component4;
import org.dcache.nfs.v4.xdr.dirlist4;
import org.dcache.nfs.v4.xdr.entry4;
import org.dcache.nfs.v4.xdr.fattr4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_cookie4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.verifier4;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.DirectoryStream;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationREADDIR
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationREADDIR.class);
    private static final int ENTRY4_SIZE = 36;
    private static final int READDIR4RESOK_SIZE = 16;
    private static final long COOKIE_OFFSET = 3L;

    OperationREADDIR(nfs_argop4 args) {
        super(args, 26);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        READDIR4res res = result.opreaddir;
        Inode dir = context.currentInode();
        verifier4 verifier = this._args.opreaddir.cookieverf;
        long startValue = this._args.opreaddir.cookie.value;
        if (startValue == 1L || startValue == 2L) {
            throw new BadCookieException("bad cookie : " + startValue);
        }
        Stat stat = context.getFs().getattr(dir);
        if (stat.type() != Stat.Type.DIRECTORY) {
            throw new NotDirException();
        }
        if (startValue != 0L) {
            startValue -= 3L;
        }
        DirectoryStream directoryStream = context.getFs().list(dir, verifier.value, startValue);
        Iterator<DirectoryEntry> dirList = directoryStream.iterator();
        if (this._args.opreaddir.maxcount.value < 16) {
            throw new TooSmallException("maxcount too small");
        }
        res.status = 0;
        res.resok4 = new READDIR4resok();
        res.resok4.reply = new dirlist4();
        res.resok4.reply.eof = true;
        res.resok4.cookieverf = new verifier4(directoryStream.getVerifier());
        int currcount = 16;
        int dircount = 0;
        entry4 lastEntry = null;
        int fcount = 0;
        while (dirList.hasNext()) {
            DirectoryEntry le = dirList.next();
            String name2 = le.getName();
            if (name2.equals(".") || name2.equals("..")) continue;
            Inode ei = le.getInode();
            entry4 currentEntry = new entry4();
            currentEntry.name = new component4(name2);
            currentEntry.cookie = new nfs_cookie4(le.getCookie() + 3L);
            try {
                currentEntry.attrs = OperationGETATTR.getAttributes(this._args.opreaddir.attr_request, context.getFs(), ei, le.getStat(), context);
            }
            catch (ChimeraNFSException e) {
                if (!this._args.opreaddir.attr_request.isSet(11)) {
                    throw e;
                }
                currentEntry.attrs = this.generateReaddirErrorAttribute(e.getStatus());
            }
            int newSize = 36 + name2.length() + currentEntry.name.value.length + currentEntry.attrs.attr_vals.value.length;
            int newDirSize = name2.length() + 4;
            if (currcount + newSize > this._args.opreaddir.maxcount.value || dircount + newDirSize > this._args.opreaddir.dircount.value) {
                if (lastEntry == null) {
                    throw new TooSmallException("can't send even a single entry");
                }
                res.resok4.reply.eof = false;
                break;
            }
            ++fcount;
            dircount += newDirSize;
            currcount += newSize;
            if (lastEntry == null) {
                res.resok4.reply.entries = currentEntry;
            } else {
                lastEntry.nextentry = currentEntry;
            }
            lastEntry = currentEntry;
        }
        _log.debug("Sending {} entries ({} bytes from {}, dircount = {}) cookie = {} EOF={}", new Object[]{fcount, currcount, this._args.opreaddir.maxcount.value, this._args.opreaddir.dircount.value, startValue, res.resok4.reply.eof});
    }

    private fattr4 generateReaddirErrorAttribute(int status) {
        fattr4 attrs = new fattr4();
        attrs.attrmask = bitmap4.of(11);
        attrs.attr_vals = new attrlist4(Ints.toByteArray((int)status));
        return attrs;
    }
}

