/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.xdr.OPEN_DOWNGRADE4res;
import org.dcache.nfs.v4.xdr.OPEN_DOWNGRADE4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationOPEN_DOWNGRADE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationOPEN_DOWNGRADE.class);

    public OperationOPEN_DOWNGRADE(nfs_argop4 args) {
        super(args, 21);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException {
        OPEN_DOWNGRADE4res res = result.opopen_downgrade;
        int shareAccess = this._args.opopen_downgrade.share_access.value & 0xFFFF00FF;
        int shareDeny = this._args.opopen_downgrade.share_deny.value & 0xFFFF00FF;
        if ((shareAccess & 3) == 0) {
            throw new InvalException("Invalid share access mode");
        }
        if ((shareAccess & 0xFFFFFFFC) != 0) {
            throw new InvalException("Invalid share access mode");
        }
        if ((shareDeny & 0xFFFFFFFC) != 0) {
            throw new InvalException("Invalid share deny mode");
        }
        Inode inode = context.currentInode();
        stateid4 stateid = Stateids.getCurrentStateidIfNeeded(context, this._args.opopen_downgrade.open_stateid);
        NFS4Client client = context.getMinorversion() > 0 ? context.getSession().getClient() : context.getStateHandler().getClientIdByStateId(stateid);
        NFS4State nfsState = client.state(stateid);
        Stateids.checkStateId(nfsState.stateid(), stateid);
        if (context.getMinorversion() == 0) {
            nfsState.getStateOwner().acceptAsNextSequence(this._args.opopen_downgrade.seqid);
        }
        res.status = 0;
        res.resok4 = new OPEN_DOWNGRADE4resok();
        res.resok4.open_stateid = context.getStateHandler().getFileTracker().downgradeOpen(client, stateid, inode, shareAccess, shareDeny);
    }
}

