/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.IsDirException;
import org.dcache.nfs.status.ServerFaultException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.StateOwner;
import org.dcache.nfs.v4.nlm.LockDeniedException;
import org.dcache.nfs.v4.nlm.LockException;
import org.dcache.nfs.v4.nlm.NlmLock;
import org.dcache.nfs.v4.xdr.LOCK4denied;
import org.dcache.nfs.v4.xdr.length4;
import org.dcache.nfs.v4.xdr.lock_owner4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.offset4;
import org.dcache.nfs.v4.xdr.state_owner4;
import org.dcache.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLOCKT
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLOCKT.class);

    public OperationLOCKT(nfs_argop4 args) {
        super(args, 13);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        Inode inode = context.currentInode();
        if (this._args.oplockt.length.value == 0L) {
            throw new InvalException("zero lock len");
        }
        switch (context.getFs().getattr(inode).type()) {
            case REGULAR: {
                break;
            }
            case DIRECTORY: {
                throw new IsDirException("lockt on directory object");
            }
            default: {
                throw new InvalException("lockt on non file object");
            }
        }
        this._args.oplockt.offset.checkOverflow(this._args.oplockt.length, "offset + len overflow");
        try {
            state_owner4 hypotheticLockOwner = new state_owner4();
            hypotheticLockOwner.owner = this._args.oplockt.owner.owner;
            if (context.getMinorversion() == 0) {
                hypotheticLockOwner.clientid = this._args.oplockt.owner.clientid;
                context.getStateHandler().getConfirmedClient(this._args.oplockt.owner.clientid);
            } else {
                hypotheticLockOwner.clientid = context.getSession().getClient().getId();
            }
            StateOwner lockOwner = new StateOwner(hypotheticLockOwner, 0);
            NlmLock lock = new NlmLock(lockOwner, this._args.oplockt.locktype, this._args.oplockt.offset.value, this._args.oplockt.length.value);
            context.getLm().test(inode.getFileId(), lock);
            result.oplockt.status = 0;
        }
        catch (LockDeniedException e) {
            result.oplockt.status = 10010;
            NlmLock conflictingLock = e.getConflictingLock();
            result.oplockt.denied = new LOCK4denied();
            result.oplockt.denied.offset = new offset4(conflictingLock.getOffset());
            result.oplockt.denied.length = new length4(conflictingLock.getLength());
            result.oplockt.denied.locktype = conflictingLock.getLockType();
            result.oplockt.denied.owner = new lock_owner4(conflictingLock.getOwner().getRawStateOwner());
        }
        catch (LockException e) {
            throw new ServerFaultException("lock error", (Throwable)e);
        }
    }
}

