/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.OpenModeException;
import org.dcache.nfs.status.ServerFaultException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.StateOwner;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.nlm.LockDeniedException;
import org.dcache.nfs.v4.nlm.LockException;
import org.dcache.nfs.v4.nlm.NlmLock;
import org.dcache.nfs.v4.xdr.LOCK4denied;
import org.dcache.nfs.v4.xdr.LOCK4resok;
import org.dcache.nfs.v4.xdr.length4;
import org.dcache.nfs.v4.xdr.lock_owner4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.offset4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLOCK
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLOCK.class);

    public OperationLOCK(nfs_argop4 args) {
        super(args, 12);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException {
        NFS4State lock_state;
        StateOwner lockOwner;
        NFS4Client client;
        Inode inode = context.currentInode();
        if (this._args.oplock.length.value == 0L) {
            throw new InvalException("zero lock len");
        }
        this._args.oplock.offset.checkOverflow(this._args.oplock.length, "offset + len overflow");
        if (this._args.oplock.locker.new_lock_owner) {
            stateid4 oldStateid = Stateids.getCurrentStateidIfNeeded(context, this._args.oplock.locker.open_owner.open_stateid);
            client = context.getMinorversion() == 0 ? context.getStateHandler().getConfirmedClient(this._args.oplock.locker.open_owner.lock_owner.clientid) : context.getSession().getClient();
            NFS4State openState = client.state(oldStateid);
            Stateids.checkStateId(openState.stateid(), oldStateid);
            if (context.getMinorversion() == 0) {
                openState.getStateOwner().acceptAsNextSequence(this._args.oplock.locker.open_owner.open_seqid);
                client.updateLeaseTime();
            }
            lockOwner = client.getOrCreateOwner(this._args.oplock.locker.open_owner.lock_owner.owner, this._args.oplock.locker.open_owner.lock_seqid);
            lock_state = client.createState(lockOwner, openState);
            lock_state.confirm();
        } else {
            stateid4 oldStateid = Stateids.getCurrentStateidIfNeeded(context, this._args.oplock.locker.lock_owner.lock_stateid);
            client = context.getStateHandler().getClientIdByStateId(oldStateid);
            lock_state = client.state(oldStateid);
            Stateids.checkStateId(lock_state.stateid(), oldStateid);
            lockOwner = lock_state.getStateOwner();
            if (context.getMinorversion() == 0) {
                lockOwner.acceptAsNextSequence(this._args.oplock.locker.lock_owner.lock_seqid);
                client.updateLeaseTime();
            }
        }
        try {
            int shareAccess;
            if ((this._args.oplock.locktype == 4 || this._args.oplock.locktype == 2) && ((shareAccess = context.getStateHandler().getFileTracker().getShareAccess(client, inode, lock_state.getOpenState().stateid())) & 2) == 0) {
                throw new OpenModeException("Invalid open mode");
            }
            NlmLock lock = new NlmLock(lockOwner, this._args.oplock.locktype, this._args.oplock.offset.value, this._args.oplock.length.value);
            context.getLm().lock(inode.getFileId(), lock);
            lock_state.addDisposeListener(s -> context.getLm().unlockIfExists(inode.getFileId(), lock));
            lock_state.bumpSeqid();
            context.currentStateid(lock_state.stateid());
            result.oplock.status = 0;
            result.oplock.resok4 = new LOCK4resok();
            result.oplock.resok4.lock_stateid = lock_state.stateid();
        }
        catch (LockDeniedException e) {
            result.oplock.status = 10010;
            NlmLock conflictingLock = e.getConflictingLock();
            result.oplock.denied = new LOCK4denied();
            result.oplock.denied.offset = new offset4(conflictingLock.getOffset());
            result.oplock.denied.length = new length4(conflictingLock.getLength());
            result.oplock.denied.locktype = conflictingLock.getLockType();
            result.oplock.denied.owner = new lock_owner4(conflictingLock.getOwner().getRawStateOwner());
        }
        catch (LockException e) {
            throw new ServerFaultException("lock error", (Throwable)e);
        }
    }
}

