/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.status.NotSuppException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.xdr.LAYOUTRETURN4res;
import org.dcache.nfs.v4.xdr.layoutreturn_stateid;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLAYOUTRETURN
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLAYOUTRETURN.class);

    OperationLAYOUTRETURN(nfs_argop4 args) {
        super(args, 51);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        LAYOUTRETURN4res res = result.oplayoutreturn;
        NFSv41DeviceManager pnfsDeviceManager = context.getDeviceManager().orElseThrow(() -> new NotSuppException("pNFS device manager not configured"));
        _log.debug("LAYOUTRETURN4args :        type: {}", (Object)this._args.oplayoutreturn.lora_layout_type);
        _log.debug("LAYOUTRETURN4args :        mode: {}", (Object)this._args.oplayoutreturn.lora_iomode);
        _log.debug("LAYOUTRETURN4args : return type: {}", (Object)this._args.oplayoutreturn.lora_layoutreturn.lr_returntype);
        _log.debug("LAYOUTRETURN4args :     reclaim: {}", (Object)this._args.oplayoutreturn.lora_reclaim);
        if (this._args.oplayoutreturn.lora_layoutreturn.lr_returntype == 1) {
            pnfsDeviceManager.layoutReturn(context, this._args.oplayoutreturn);
        }
        res.lorr_stateid = new layoutreturn_stateid();
        res.lorr_stateid.lrs_present = false;
        res.lorr_stateid.lrs_stateid = Stateids.ZeroStateId();
        res.lorr_status = 0;
    }
}

