/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.NoXattrException;
import org.dcache.nfs.status.NotSuppException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.xattrvalue4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.oncrpc4j.rpc.OncRpcException;

public class OperationGETXATTR
extends AbstractNFSv4Operation {
    public OperationGETXATTR(nfs_argop4 args) {
        super(args, 72);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        try {
            Inode inode = context.currentInode();
            byte[] value = context.getFs().getXattr(inode, this._args.opgetxattr.gxa_name);
            result.opgetxattr.gxr_value = new xattrvalue4(value);
            result.setStatus(0);
        }
        catch (NotSuppException e) {
            throw e;
        }
        catch (IOException e) {
            throw new NoXattrException();
        }
    }
}

