/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.status.NotSuppException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.xdr.GETDEVICEINFO4res;
import org.dcache.nfs.v4.xdr.GETDEVICEINFO4resok;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.device_addr4;
import org.dcache.nfs.v4.xdr.deviceid4;
import org.dcache.nfs.v4.xdr.layouttype4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationGETDEVICEINFO
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationGETDEVICEINFO.class);

    public OperationGETDEVICEINFO(nfs_argop4 args) {
        super(args, 47);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        GETDEVICEINFO4res res = result.opgetdeviceinfo;
        NFSv41DeviceManager pnfsDeviceManager = context.getDeviceManager().orElseThrow(() -> new NotSuppException("pNFS device manager not configured"));
        deviceid4 deviceId = this._args.opgetdeviceinfo.gdia_device_id;
        _log.debug("Get device info for device [{}], type {} ", (Object)deviceId, (Object)this._args.opgetdeviceinfo.gdia_layout_type);
        res.gdir_resok4 = new GETDEVICEINFO4resok();
        layouttype4 layoutType = layouttype4.valueOf(this._args.opgetdeviceinfo.gdia_layout_type);
        device_addr4 deviceInfo = pnfsDeviceManager.getDeviceInfo(context, this._args.opgetdeviceinfo);
        if (deviceInfo == null) {
            throw new NoEntException("invalid deviceInfo id [" + deviceId + "]");
        }
        res.gdir_resok4.gdir_device_addr = deviceInfo;
        res.gdir_resok4.gdir_notification = new bitmap4(new int[this._args.opgetdeviceinfo.gdia_notify_types.value.length]);
        if (this._args.opgetdeviceinfo.gdia_notify_types.isSet(1)) {
            res.gdir_resok4.gdir_notification.set(1);
        }
        if (this._args.opgetdeviceinfo.gdia_notify_types.isSet(2)) {
            res.gdir_resok4.gdir_notification.set(2);
        }
        res.gdir_status = 0;
    }
}

