/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.CodeSource;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.AccessException;
import org.dcache.nfs.status.BadXdrException;
import org.dcache.nfs.status.ClidInUseException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.status.NotSameException;
import org.dcache.nfs.status.PermException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFSv4StateHandler;
import org.dcache.nfs.v4.ServerIdProvider;
import org.dcache.nfs.v4.xdr.EXCHANGE_ID4res;
import org.dcache.nfs.v4.xdr.EXCHANGE_ID4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_impl_id4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.nfstime4;
import org.dcache.nfs.v4.xdr.sequenceid4;
import org.dcache.nfs.v4.xdr.state_protect4_r;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.v4.xdr.utf8str_cis;
import org.dcache.nfs.v4.xdr.utf8str_cs;
import org.dcache.nfs.v4.xdr.verifier4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationEXCHANGE_ID
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationEXCHANGE_ID.class);
    private static final int EXCHGID4_FLAG_MASK = -1073282813;
    private static long COMPILE_TIME = 0L;

    public OperationEXCHANGE_ID(nfs_argop4 args) {
        super(args, 42);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException {
        boolean needCallBack;
        EXCHANGE_ID4res res = result.opexchange_id;
        byte[] clientOwner = this._args.opexchange_id.eia_clientowner.co_ownerid;
        if (this._args.opexchange_id.eia_state_protect.spa_how != 0 && this._args.opexchange_id.eia_state_protect.spa_how != 1 && this._args.opexchange_id.eia_state_protect.spa_how != 2) {
            _log.debug("EXCHANGE_ID4: state protection : {}", (Object)this._args.opexchange_id.eia_state_protect.spa_how);
            throw new InvalException("invalid state protection");
        }
        if (this._args.opexchange_id.eia_flags.value != 0 && (this._args.opexchange_id.eia_flags.value | 0xC0070103) != -1073282813) {
            throw new InvalException("invalid flag");
        }
        if (this._args.opexchange_id.eia_client_impl_id.length > 1) {
            throw new BadXdrException("invalid array size of client implementaion");
        }
        if (this._args.opexchange_id.eia_flags.value != 0 && (this._args.opexchange_id.eia_flags.value & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            throw new InvalException("Client used server-only flag");
        }
        if (this._args.opexchange_id.eia_state_protect.spa_how != 0) {
            _log.debug("Tried the wrong security Option! {}:", (Object)this._args.opexchange_id.eia_state_protect.spa_how);
            throw new AccessException("SSV other than SP4NONE to use");
        }
        NFS4Client client = context.getStateHandler().clientByOwner(clientOwner);
        Principal principal = context.getPrincipal();
        verifier4 verifier = this._args.opexchange_id.eia_clientowner.co_verifier;
        boolean update = (this._args.opexchange_id.eia_flags.value & 0x40000000) != 0;
        InetSocketAddress remoteSocketAddress = context.getRemoteSocketAddress();
        InetSocketAddress localSocketAddress = context.getLocalSocketAddress();
        NFSv4StateHandler stateHandler = context.getStateHandler();
        int exchangeIdFlags = context.getExchangeIdFlags();
        boolean bl = needCallBack = (exchangeIdFlags & 0x70000) != 262144;
        if (update) {
            if (client == null || !client.isConfirmed()) {
                _log.debug("Update of no existing/confirmed Record (case 7)");
                throw new NoEntException("no such client");
            }
            if (!client.verifierEquals(verifier)) {
                _log.debug("case 8: Update but Wrong Verifier");
                throw new NotSameException("Update but Wrong Verifier");
            }
            if (!principal.equals(client.principal())) {
                _log.debug("case 9: Update but Wrong Principal");
                throw new PermException("Principal Mismatch");
            }
            _log.debug("Case 6: Update");
            client.refreshLeaseTime();
        } else if (client == null) {
            _log.debug("Case 1: New Owner ID");
            client = stateHandler.createClient(remoteSocketAddress, localSocketAddress, context.getMinorversion(), clientOwner, this._args.opexchange_id.eia_clientowner.co_verifier, principal, needCallBack);
        } else if (client.isConfirmed()) {
            if (client.verifierEquals(verifier) && principal.equals(client.principal())) {
                _log.debug("Case 2: Non-Update on Existing Client ID");
                client.refreshLeaseTime();
            } else if (principal.equals(client.principal())) {
                _log.debug("case 5: Client Restart");
                stateHandler.removeClient(client);
                client = stateHandler.createClient(remoteSocketAddress, localSocketAddress, context.getMinorversion(), clientOwner, this._args.opexchange_id.eia_clientowner.co_verifier, principal, needCallBack);
            } else {
                _log.debug("Case 3b: Client Collision");
                if (client.hasState() && client.isLeaseValid()) throw new ClidInUseException("Principal Missmatch");
                stateHandler.removeClient(client);
                client = stateHandler.createClient(remoteSocketAddress, localSocketAddress, context.getMinorversion(), clientOwner, this._args.opexchange_id.eia_clientowner.co_verifier, principal, needCallBack);
            }
        } else {
            _log.debug("case 4: Replacement of Unconfirmed Record");
            stateHandler.removeClient(client);
            client = stateHandler.createClient(remoteSocketAddress, localSocketAddress, context.getMinorversion(), this._args.opexchange_id.eia_clientowner.co_ownerid, this._args.opexchange_id.eia_clientowner.co_verifier, principal, needCallBack);
        }
        client.updateLeaseTime();
        res.eir_resok4 = new EXCHANGE_ID4resok();
        res.eir_resok4.eir_clientid = client.getId();
        res.eir_resok4.eir_sequenceid = new sequenceid4(client.currentSeqID());
        res.eir_resok4.eir_flags = new uint32_t(exchangeIdFlags);
        ServerIdProvider serverIdProvider = context.getServerIdProvider();
        res.eir_resok4.eir_server_owner = serverIdProvider.getOwner();
        res.eir_resok4.eir_server_scope = serverIdProvider.getScope();
        res.eir_resok4.eir_server_impl_id = new nfs_impl_id4[1];
        res.eir_resok4.eir_server_impl_id[0] = new nfs_impl_id4();
        res.eir_resok4.eir_server_impl_id[0].nii_domain = new utf8str_cis("dCache.ORG");
        res.eir_resok4.eir_server_impl_id[0].nii_name = new utf8str_cs("Chimera NFSv4.1");
        res.eir_resok4.eir_server_impl_id[0].nii_date = new nfstime4(COMPILE_TIME);
        res.eir_resok4.eir_state_protect = new state_protect4_r();
        res.eir_resok4.eir_state_protect.spr_how = 0;
        if (!client.isConfirmed()) return;
        res.eir_resok4.eir_flags = new uint32_t(res.eir_resok4.eir_flags.value | Integer.MIN_VALUE);
    }

    static {
        try {
            Attributes as;
            String buildTime;
            ProtectionDomain pd = OperationEXCHANGE_ID.class.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            URL u = cs.getLocation();
            InputStream is = u.openStream();
            JarInputStream jis = new JarInputStream(is);
            Manifest m = jis.getManifest();
            if (m != null && (buildTime = (as = m.getMainAttributes()).getValue("Build-Time")) != null) {
                Instant dateTime = Instant.parse(buildTime);
                COMPILE_TIME = dateTime.toEpochMilli();
            }
        }
        catch (IOException | DateTimeParseException e) {
            _log.warn("Failed to get compile time: {}", (Object)e.getMessage());
        }
    }
}

