/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadXdrException;
import org.dcache.nfs.status.ClidInUseException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.ClientCB;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFSv41Session;
import org.dcache.nfs.v4.xdr.CREATE_SESSION4res;
import org.dcache.nfs.v4.xdr.CREATE_SESSION4resok;
import org.dcache.nfs.v4.xdr.count4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCREATE_SESSION
extends AbstractNFSv4Operation {
    private static final int SESSION_FLAGS_MASK = 7;
    private static final Logger _log = LoggerFactory.getLogger(OperationCREATE_SESSION.class);

    public OperationCREATE_SESSION(nfs_argop4 args) {
        super(args, 43);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException {
        CREATE_SESSION4res res = result.opcreate_session;
        int sessionFlags = 0;
        if (this._args.opcreate_session.csa_fore_chan_attrs.ca_rdma_ird.length > 1) {
            throw new BadXdrException("bad size of rdma_ird");
        }
        if ((this._args.opcreate_session.csa_flags.value & 0xFFFFFFF8) != 0) {
            throw new InvalException("bad ceate_session flag");
        }
        NFS4Client client = context.getStateHandler().getValidClient(this._args.opcreate_session.csa_clientid);
        if (!client.principal().equals(context.getPrincipal()) && !client.isConfirmed()) {
            throw new ClidInUseException("client already in use: " + client.principal() + " " + context.getPrincipal());
        }
        NFSv41Session session = client.createSession(this._args.opcreate_session.csa_sequence.value, Math.min(16, this._args.opcreate_session.csa_fore_chan_attrs.ca_maxrequests.value), Math.min(16, this._args.opcreate_session.csa_back_chan_attrs.ca_maxrequests.value), Math.min(128, this._args.opcreate_session.csa_fore_chan_attrs.ca_maxoperations.value), Math.min(128, this._args.opcreate_session.csa_back_chan_attrs.ca_maxoperations.value));
        _log.debug("adding new session [{}]", (Object)session);
        if (client.isCallbackNeede() && (this._args.opcreate_session.csa_flags.value & 2) != 0) {
            ClientCB cb = new ClientCB(context.getRpcCall().getTransport().getPeerTransport(), this._args.opcreate_session.csa_cb_program.value, context.getMinorversion(), session.id(), this._args.opcreate_session.csa_back_chan_attrs.ca_maxrequests.value, this._args.opcreate_session.csa_sec_parms);
            try {
                cb.cbPing();
                client.setCB(cb);
                sessionFlags |= 2;
            }
            catch (IOException | TimeoutException e) {
                _log.info("Can't ping client over back channel: {}", (Object)e.getMessage());
            }
        }
        client.refreshLeaseTime();
        res.csr_resok4 = new CREATE_SESSION4resok();
        res.csr_resok4.csr_sessionid = session.id();
        res.csr_resok4.csr_sequence = this._args.opcreate_session.csa_sequence;
        res.csr_resok4.csr_flags = new uint32_t(sessionFlags);
        res.csr_resok4.csr_fore_chan_attrs = this._args.opcreate_session.csa_fore_chan_attrs;
        res.csr_resok4.csr_fore_chan_attrs.ca_maxoperations = new count4(session.getMaxOps());
        res.csr_resok4.csr_fore_chan_attrs.ca_maxrequests = new count4(session.getHighestSlot() + 1);
        res.csr_resok4.csr_back_chan_attrs = this._args.opcreate_session.csa_back_chan_attrs;
        res.csr_resok4.csr_back_chan_attrs.ca_maxoperations = new count4(session.getMaxCbOps());
        res.csr_resok4.csr_back_chan_attrs.ca_maxrequests = new count4(session.getCbHighestSlot() + 1);
        res.csr_status = 0;
    }
}

