/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.xdr.CLOSE4res;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCLOSE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationCLOSE.class);

    public OperationCLOSE(nfs_argop4 args) {
        super(args, 4);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        CLOSE4res res = result.opclose;
        Inode inode = context.currentInode();
        stateid4 stateid = Stateids.getCurrentStateidIfNeeded(context, this._args.opclose.open_stateid);
        NFS4Client client = context.getMinorversion() > 0 ? context.getSession().getClient() : context.getStateHandler().getClientIdByStateId(stateid);
        NFS4State nfsState = client.state(stateid);
        Stateids.checkStateId(nfsState.stateid(), stateid);
        if (context.getMinorversion() == 0) {
            nfsState.getStateOwner().acceptAsNextSequence(this._args.opclose.seqid);
            client.updateLeaseTime();
        }
        client.tryReleaseState(stateid);
        res.open_stateid = Stateids.invalidStateId();
        res.status = 0;
    }
}

