/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.base.Utf8;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadNameException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.NameTooLongException;

class NameFilter {
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    private NameFilter() {
    }

    public static String convertName(byte[] bytes) throws ChimeraNFSException {
        String name2 = NameFilter.convertPath(bytes);
        if (name2.length() > 255) {
            throw new NameTooLongException("name too long");
        }
        if (name2.equals(".") || name2.equals("..")) {
            throw new BadNameException("bad name '.' or '..'");
        }
        if (name2.indexOf(47) != -1) {
            throw new BadNameException("name with slash '/'");
        }
        return name2;
    }

    public static String convertPath(byte[] bytes) throws ChimeraNFSException {
        if (!Utf8.isWellFormed((byte[])bytes)) {
            throw new InvalException("invalid utf8 name");
        }
        String name2 = new String(bytes, UTF8);
        if (name2.length() == 0) {
            throw new InvalException("bad path name");
        }
        if (name2.indexOf(0) != -1) {
            throw new BadNameException("name with null");
        }
        return name2;
    }
}

