/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.ExportFile;
import org.dcache.nfs.ExportTable;
import org.dcache.nfs.status.MinorVersMismatchException;
import org.dcache.nfs.status.NotOnlyOpException;
import org.dcache.nfs.status.OpNotInSessionException;
import org.dcache.nfs.status.ResourceException;
import org.dcache.nfs.status.RetryUncacheRepException;
import org.dcache.nfs.status.SequencePosException;
import org.dcache.nfs.status.TooManyOpsException;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.CompoundContextBuilder;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.NFSv4StateHandler;
import org.dcache.nfs.v4.OperationExecutor;
import org.dcache.nfs.v4.nlm.LockManager;
import org.dcache.nfs.v4.nlm.SimpleLm;
import org.dcache.nfs.v4.xdr.COMPOUND4args;
import org.dcache.nfs.v4.xdr.COMPOUND4res;
import org.dcache.nfs.v4.xdr.nfs4_prot_NFS4_PROGRAM_ServerStub;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.verifier4;
import org.dcache.nfs.vfs.PseudoFs;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class NFSServerV41
extends nfs4_prot_NFS4_PROGRAM_ServerStub {
    private static final Logger _log = LoggerFactory.getLogger(NFSServerV41.class);
    private final VirtualFileSystem _fs;
    private final ExportTable _exportTable;
    private final OperationExecutor _operationExecutor;
    private final NFSv41DeviceManager _deviceManager;
    private final NFSv4StateHandler _statHandler;
    private final LockManager _nlm;
    private final verifier4 _rebootVerifier = verifier4.valueOf(System.currentTimeMillis());

    private NFSServerV41(Builder builder) {
        this._deviceManager = builder.deviceManager;
        this._fs = builder.vfs;
        this._exportTable = builder.exportTable;
        this._operationExecutor = builder.operationExecutor;
        this._nlm = builder.nlm == null ? new SimpleLm() : builder.nlm;
        this._statHandler = builder.stateHandler == null ? new NFSv4StateHandler() : builder.stateHandler;
    }

    @Deprecated
    public NFSServerV41(OperationExecutor operationExecutor, NFSv41DeviceManager deviceManager, VirtualFileSystem fs, ExportTable exportTable) {
        this._deviceManager = deviceManager;
        this._fs = fs;
        this._exportTable = exportTable;
        this._operationExecutor = operationExecutor;
        this._nlm = new SimpleLm();
        this._statHandler = new NFSv4StateHandler();
    }

    @Override
    public void NFSPROC4_NULL_4(RpcCall call$) {
        _log.debug("NFS PING client: {}", (Object)call$.getTransport().getRemoteSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public COMPOUND4res NFSPROC4_COMPOUND_4(RpcCall call$, COMPOUND4args arg1) {
        COMPOUND4res res = new COMPOUND4res();
        try {
            res.tag = arg1.tag;
            String tag = arg1.tag.toString();
            MDC.put((String)"mdc.tag", (String)tag);
            MDC.put((String)"mdc.client", (String)call$.getTransport().getRemoteSocketAddress().toString());
            _log.debug("NFS COMPOUND client: {}, tag: [{}]", (Object)call$.getTransport().getRemoteSocketAddress(), (Object)tag);
            int minorversion = arg1.minorversion.value;
            if (minorversion > 2) {
                throw new MinorVersMismatchException(String.format("Unsupported minor version [%d]", arg1.minorversion.value));
            }
            if (arg1.argarray.length >= 128 && minorversion == 0) {
                throw new ResourceException(String.format("Too many ops [%d]", arg1.argarray.length));
            }
            res.resarray = new ArrayList<nfs_resop4>(arg1.argarray.length);
            PseudoFs fs = new PseudoFs(this._fs, call$, this._exportTable);
            CompoundContextBuilder builder = new CompoundContextBuilder().withMinorversion(arg1.minorversion.value).withFs(fs).withDeviceManager(this._deviceManager).withStateHandler(this._statHandler).withLockManager(this._nlm).withExportTable(this._exportTable).withRebootVerifier(this._rebootVerifier).withCall(call$);
            if (this._deviceManager != null) {
                builder.withPnfsRoleMDS();
                builder.withPnfsRoleDS();
            } else if (this._exportTable == null) {
                builder.withPnfsRoleDS();
            } else {
                builder.withoutPnfs();
            }
            CompoundContext context = builder.build();
            boolean retransmit = false;
            for (int position = 0; position < arg1.argarray.length; ++position) {
                nfs_argop4 op = arg1.argarray[position];
                if (minorversion != 0) {
                    NFSServerV41.checkOpPosition(op.argop, position, arg1.argarray.length);
                    if (position == 1) {
                        if (arg1.argarray.length > context.getSession().getMaxOps()) {
                            throw new TooManyOpsException(String.format("Too many ops [%d]", arg1.argarray.length));
                        }
                        List<nfs_resop4> cache = context.getCache();
                        if (cache != null) {
                            if (cache.isEmpty()) {
                                throw new RetryUncacheRepException();
                            }
                            res.resarray.addAll(cache.subList(position, cache.size()));
                            res.status = NFSServerV41.statusOfLastOperation(cache);
                            retransmit = true;
                            break;
                        }
                    }
                }
                nfs_resop4 opResult = this._operationExecutor.execute(context, op);
                res.resarray.add(opResult);
                res.status = opResult.getStatus();
                if (res.status != 0) break;
            }
            if (!retransmit && context.cacheThis()) {
                context.getSessionSlot().update(res.resarray);
            }
            _log.debug("OP: [{}] status: {}", (Object)res.tag, (Object)res.status);
        }
        catch (ChimeraNFSException e) {
            _log.info("NFS operation failed: {}", (Object)e.getMessage());
            res.resarray = Collections.emptyList();
            res.status = e.getStatus();
        }
        catch (Exception e) {
            _log.error("Unhandled exception:", (Throwable)e);
            res.resarray = Collections.emptyList();
            res.status = 10006;
        }
        finally {
            MDC.remove((String)"mdc.tag");
            MDC.remove((String)"mdc.client");
            MDC.remove((String)"mdc.session");
        }
        return res;
    }

    public NFSv4StateHandler getStateHandler() {
        return this._statHandler;
    }

    private static void checkOpPosition(int opCode, int position, int total) throws ChimeraNFSException {
        if (opCode > 58 || opCode < 3) {
            return;
        }
        if (position == 0) {
            switch (opCode) {
                case 42: 
                case 43: 
                case 44: 
                case 53: 
                case 57: {
                    break;
                }
                default: {
                    throw new OpNotInSessionException();
                }
            }
            if (total > 1) {
                switch (opCode) {
                    case 42: 
                    case 43: 
                    case 57: {
                        throw new NotOnlyOpException();
                    }
                }
            }
        } else {
            switch (opCode) {
                case 53: {
                    throw new SequencePosException();
                }
            }
        }
    }

    private static int statusOfLastOperation(List<nfs_resop4> ops) {
        return ops.get(ops.size() - 1).getStatus();
    }

    public static class Builder {
        private OperationExecutor operationExecutor;
        private NFSv41DeviceManager deviceManager;
        private VirtualFileSystem vfs;
        private ExportTable exportTable;
        private LockManager nlm;
        private NFSv4StateHandler stateHandler;

        public Builder withDeviceManager(NFSv41DeviceManager deviceManager) {
            this.deviceManager = deviceManager;
            return this;
        }

        public Builder withOperationExecutor(OperationExecutor operationFactory) {
            this.operationExecutor = operationFactory;
            return this;
        }

        public Builder withVfs(VirtualFileSystem vfs) {
            this.vfs = vfs;
            return this;
        }

        public Builder withLockManager(LockManager nlm) {
            this.nlm = nlm;
            return this;
        }

        public Builder withExportTable(ExportTable exportTable) {
            this.exportTable = exportTable;
            return this;
        }

        @Deprecated
        public Builder withExportFile(ExportFile exportFile) {
            return this.withExportTable(exportFile);
        }

        public Builder withStateHandler(NFSv4StateHandler stateHandler) {
            this.stateHandler = stateHandler;
            return this;
        }

        public NFSServerV41 build() {
            return new NFSServerV41(this);
        }
    }
}

