/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.StateDisposeListener;
import org.dcache.nfs.v4.StateOwner;
import org.dcache.nfs.v4.xdr.stateid4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFS4State {
    private static final Logger LOG = LoggerFactory.getLogger(NFS4State.class);
    private final stateid4 _stateid;
    private final StateOwner _owner;
    private boolean _isConfimed = false;
    private boolean _disposed = false;
    private final NFS4State _openState;
    private final List<StateDisposeListener> _disposeListeners;

    public NFS4State(StateOwner owner, stateid4 stateid) {
        this(null, owner, stateid);
    }

    public NFS4State(NFS4State openState, StateOwner owner, stateid4 stateid) {
        this._openState = openState;
        this._owner = owner;
        this._stateid = stateid;
        this._disposeListeners = new ArrayList<StateDisposeListener>();
    }

    public void bumpSeqid() {
        ++this._stateid.seqid;
    }

    public stateid4 stateid() {
        return this._stateid;
    }

    public void confirm() {
        this._isConfimed = true;
    }

    public boolean isConfimed() {
        return this._isConfimed;
    }

    public final synchronized void tryDispose() throws ChimeraNFSException {
        if (!this._disposed) {
            Iterator<StateDisposeListener> i = this._disposeListeners.iterator();
            while (i.hasNext()) {
                StateDisposeListener listener = i.next();
                listener.notifyDisposed(this);
                i.remove();
            }
            this.dispose();
            this._disposed = true;
        }
    }

    public final synchronized void disposeIgnoreFailures() {
        if (!this._disposed) {
            Iterator<StateDisposeListener> i = this._disposeListeners.iterator();
            while (i.hasNext()) {
                StateDisposeListener listener = i.next();
                try {
                    listener.notifyDisposed(this);
                }
                catch (ChimeraNFSException e) {
                    LOG.info("failed to notify: {}", (Object)e.getMessage());
                }
                i.remove();
            }
            this.dispose();
            this._disposed = true;
        }
    }

    public NFS4State getOpenState() {
        return this._openState == null ? this : this._openState;
    }

    protected void dispose() {
    }

    public StateOwner getStateOwner() {
        return this._owner;
    }

    public synchronized void addDisposeListener(StateDisposeListener disposeListener) {
        this._disposeListeners.add(disposeListener);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("stateid", (Object)this._stateid).add("open-stateid", this._openState == null ? null : this._openState.stateid()).add("owner", (Object)this._owner).add("confirmed", this._isConfimed).omitNullValues().toString();
    }
}

