/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.function.BiConsumer;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadXdrException;
import org.dcache.nfs.status.ServerFaultException;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.LayoutDriver;
import org.dcache.nfs.v4.ff.ff_data_server4;
import org.dcache.nfs.v4.ff.ff_device_addr4;
import org.dcache.nfs.v4.ff.ff_device_versions4;
import org.dcache.nfs.v4.ff.ff_layout4;
import org.dcache.nfs.v4.ff.ff_layoutreturn4;
import org.dcache.nfs.v4.ff.ff_mirror4;
import org.dcache.nfs.v4.xdr.device_addr4;
import org.dcache.nfs.v4.xdr.deviceid4;
import org.dcache.nfs.v4.xdr.fattr4_owner;
import org.dcache.nfs.v4.xdr.fattr4_owner_group;
import org.dcache.nfs.v4.xdr.layout_content4;
import org.dcache.nfs.v4.xdr.layouttype4;
import org.dcache.nfs.v4.xdr.length4;
import org.dcache.nfs.v4.xdr.multipath_list4;
import org.dcache.nfs.v4.xdr.netaddr4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.v4.xdr.utf8str_mixed;
import org.dcache.oncrpc4j.xdr.Xdr;
import org.dcache.oncrpc4j.xdr.XdrDecodingStream;
import org.dcache.oncrpc4j.xdr.XdrEncodingStream;

public class FlexFileLayoutDriver
implements LayoutDriver {
    private final int nfsVersion;
    private final int nfsMinorVersion;
    private final fattr4_owner userPrincipal;
    private final fattr4_owner_group groupPrincipal;
    private final BiConsumer<CompoundContext, ff_layoutreturn4> layoutReturnConsumer;
    private final uint32_t layoutFlags;
    private final uint32_t ioBufferSize;

    public FlexFileLayoutDriver(int nfsVersion, int nfsMinorVersion, int flags, int ioBufferSize, utf8str_mixed userPrincipal, utf8str_mixed groupPrincipal, BiConsumer<CompoundContext, ff_layoutreturn4> layoutReturnConsumer) {
        Preconditions.checkArgument(((flags & 0xFFFFFFF0) == 0 ? 1 : 0) != 0, (Object)"Invalid flex files layout flag");
        this.nfsVersion = nfsVersion;
        this.nfsMinorVersion = nfsMinorVersion;
        this.userPrincipal = new fattr4_owner(userPrincipal);
        this.groupPrincipal = new fattr4_owner_group(groupPrincipal);
        this.layoutReturnConsumer = layoutReturnConsumer;
        this.ioBufferSize = new uint32_t(ioBufferSize);
        this.layoutFlags = new uint32_t(flags);
    }

    @Override
    public layouttype4 getLayoutType() {
        return layouttype4.LAYOUT4_FLEX_FILES;
    }

    @Override
    public device_addr4 getDeviceAddress(InetSocketAddress ... deviceAddress) throws ChimeraNFSException {
        device_addr4 device_addr42;
        ff_device_addr4 flexfile_type = new ff_device_addr4();
        flexfile_type.ffda_versions = new ff_device_versions4[1];
        flexfile_type.ffda_versions[0] = new ff_device_versions4();
        flexfile_type.ffda_versions[0].ffdv_version = new uint32_t(this.nfsVersion);
        flexfile_type.ffda_versions[0].ffdv_minorversion = new uint32_t(this.nfsMinorVersion);
        flexfile_type.ffda_versions[0].ffdv_rsize = this.ioBufferSize;
        flexfile_type.ffda_versions[0].ffdv_wsize = this.ioBufferSize;
        flexfile_type.ffda_versions[0].ffdv_tightly_coupled = true;
        flexfile_type.ffda_netaddrs = new multipath_list4();
        flexfile_type.ffda_netaddrs.value = new netaddr4[deviceAddress.length];
        for (int i = 0; i < deviceAddress.length; ++i) {
            flexfile_type.ffda_netaddrs.value[i] = new netaddr4(deviceAddress[i]);
        }
        Xdr xdr = new Xdr(128);
        try {
            xdr.beginEncoding();
            flexfile_type.xdrEncode((XdrEncodingStream)xdr);
            xdr.endEncoding();
            device_addr4 addr = new device_addr4();
            addr.da_layout_type = layouttype4.LAYOUT4_FLEX_FILES.getValue();
            addr.da_addr_body = xdr.getBytes();
            device_addr42 = addr;
        }
        catch (Throwable throwable) {
            try {
                try {
                    xdr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected IOException:" + e.getMessage(), e);
            }
        }
        xdr.close();
        return device_addr42;
    }

    @Override
    public layout_content4 getLayoutContent(stateid4 stateid, int stripeSize, nfs_fh4 fh, deviceid4 ... deviceids) throws ChimeraNFSException {
        layout_content4 layout_content42;
        Preconditions.checkArgument((deviceids.length > 0 ? 1 : 0) != 0, (Object)"Layout driver supports need at least one (1) device.");
        ff_layout4 layout = new ff_layout4();
        layout.ffl_stripe_unit = new length4(0L);
        layout.ffl_mirrors = this.createMirrors(deviceids, 0, stateid, fh);
        layout.ffl_flags4 = this.layoutFlags;
        layout.ffl_stats_collect_hint = new uint32_t(0);
        Xdr xdr = new Xdr(512);
        try {
            xdr.beginEncoding();
            layout.xdrEncode((XdrEncodingStream)xdr);
            xdr.endEncoding();
            layout_content4 content = new layout_content4();
            content.loc_type = layouttype4.LAYOUT4_FLEX_FILES.getValue();
            content.loc_body = xdr.getBytes();
            layout_content42 = content;
        }
        catch (Throwable throwable) {
            try {
                try {
                    xdr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ServerFaultException("failed to encode layout body", (Throwable)e);
            }
        }
        xdr.close();
        return layout_content42;
    }

    private ff_data_server4 createDataserver(deviceid4 deviceid, int efficiency, stateid4 stateid, nfs_fh4 fileHandle) {
        ff_data_server4 ds = new ff_data_server4();
        ds.ffds_deviceid = deviceid;
        ds.ffds_efficiency = new uint32_t(efficiency);
        ds.ffds_stateid = stateid;
        ds.ffds_fh_vers = new nfs_fh4[]{fileHandle};
        ds.ffds_user = this.userPrincipal;
        ds.ffds_group = this.groupPrincipal;
        return ds;
    }

    private ff_mirror4[] createMirrors(deviceid4[] deviceids, int efficiency, stateid4 stateid, nfs_fh4 fileHandle) {
        ff_mirror4[] mirrors = new ff_mirror4[deviceids.length];
        for (int i = 0; i < deviceids.length; ++i) {
            mirrors[i] = new ff_mirror4();
            mirrors[i].ffm_data_servers = new ff_data_server4[1];
            mirrors[i].ffm_data_servers[0] = this.createDataserver(deviceids[i], efficiency, stateid, fileHandle);
        }
        return mirrors;
    }

    @Override
    public void acceptLayoutReturnData(CompoundContext context, byte[] data) throws BadXdrException {
        try {
            ff_layoutreturn4 lr;
            try (Xdr xdr = new Xdr(data);){
                xdr.beginDecoding();
                lr = new ff_layoutreturn4((XdrDecodingStream)xdr);
                xdr.endDecoding();
            }
            this.layoutReturnConsumer.accept(context, lr);
        }
        catch (IOException e) {
            throw new BadXdrException("invalid data", (Throwable)e);
        }
    }
}

