/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.dcache.nfs.util.Cache;
import org.dcache.nfs.util.CacheElement;
import org.dcache.nfs.util.CacheEventListener;
import org.dcache.nfs.v4.ClientCache;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.xdr.clientid4;

public class DefaultClientCache
extends Cache<clientid4, NFS4Client>
implements ClientCache {
    public DefaultClientCache(int leaseTime, CacheEventListener<clientid4, NFS4Client> eventListener) {
        super("NFSv41 clients", 5000, Long.MAX_VALUE, TimeUnit.SECONDS.toMillis(leaseTime * 2), eventListener);
    }

    @Override
    public Stream<NFS4Client> stream() {
        return this.entries().stream().map(CacheElement::getObject);
    }

    @Override
    public Stream<NFS4Client> peek() {
        return this.entries().stream().map(CacheElement::peekObject);
    }
}

