/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.sun.security.auth.UnixNumericUserPrincipal;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.ExportTable;
import org.dcache.nfs.status.BadStateidException;
import org.dcache.nfs.status.NoFileHandleException;
import org.dcache.nfs.status.RestoreFhException;
import org.dcache.nfs.v4.CompoundContextBuilder;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.NFSv41Session;
import org.dcache.nfs.v4.NFSv4StateHandler;
import org.dcache.nfs.v4.ServerIdProvider;
import org.dcache.nfs.v4.SessionSlot;
import org.dcache.nfs.v4.nlm.LockManager;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.server_owner4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.uint64_t;
import org.dcache.nfs.v4.xdr.verifier4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.net.InetSocketAddresses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundContext {
    private static final Logger _log = LoggerFactory.getLogger(CompoundContext.class);
    private static final Principal NO_PRINCIPAL = new Principal(){
        private final String _name = "";

        @Override
        public String getName() {
            return "";
        }

        @Override
        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj != null && obj.getClass().isInstance(this);
        }
    };
    private Inode _currentInode = null;
    private Inode _savedInode = null;
    private final int _minorversion;
    private NFSv41Session _session = null;
    private final VirtualFileSystem _fs;
    private final RpcCall _callInfo;
    private final Subject _subject;
    private final ExportTable _exportTable;
    private final Optional<NFSv41DeviceManager> _deviceManager;
    private final NFSv4StateHandler _stateHandler;
    private SessionSlot _slot;
    private boolean _cacheThis;
    private stateid4 _currentStateid = null;
    private stateid4 _savedStateid = null;
    private final Principal _principal;
    private final LockManager _nlm;
    private final int _exchangeIdFlags;
    private final verifier4 _rebootVerifier;
    private List<nfs_resop4> _cache;

    public CompoundContext(CompoundContextBuilder builder) {
        this._minorversion = builder.getMinorversion();
        this._fs = builder.getFs();
        this._deviceManager = Optional.ofNullable(builder.getDeviceManager());
        this._callInfo = builder.getCall();
        this._exportTable = builder.getExportTable();
        this._stateHandler = builder.getStateHandler();
        this._nlm = builder.getLm();
        this._subject = this._callInfo.getCredential().getSubject();
        this._principal = this.principalOf(this._callInfo);
        this._exchangeIdFlags = builder.getExchangeIdFlags();
        this._rebootVerifier = builder.getRebootVerifier();
    }

    public RpcCall getRpcCall() {
        return this._callInfo;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public VirtualFileSystem getFs() {
        return this._fs;
    }

    public Optional<NFSv41DeviceManager> getDeviceManager() {
        return this._deviceManager;
    }

    public LockManager getLm() {
        return this._nlm;
    }

    public int getMinorversion() {
        return this._minorversion;
    }

    public Inode currentInode() throws ChimeraNFSException {
        if (this._currentInode == null) {
            throw new NoFileHandleException("no file handle");
        }
        return this._currentInode;
    }

    public void currentInode(Inode inode) throws ChimeraNFSException {
        this._currentInode = inode;
        _log.debug("current Inode: {}", (Object)this._currentInode);
    }

    public void clearCurrentInode() throws ChimeraNFSException {
        this._currentInode = null;
    }

    public void restoreSavedInode() throws ChimeraNFSException {
        if (this._savedInode == null) {
            throw new RestoreFhException("no saved file handle");
        }
        this._currentInode = this._savedInode;
        this._currentStateid = this._savedStateid;
        _log.debug("restored Inode: {}", (Object)this._currentInode);
    }

    public Inode savedInode() throws ChimeraNFSException {
        if (this._savedInode == null) {
            throw new NoFileHandleException("no file handle");
        }
        return this._savedInode;
    }

    public void saveCurrentInode() throws ChimeraNFSException {
        if (this._currentInode == null) {
            throw new NoFileHandleException("no file handle");
        }
        this._savedInode = this._currentInode;
        this._savedStateid = this._currentStateid;
        _log.debug("saved Inode: {}", (Object)this._savedInode);
    }

    public void setSession(NFSv41Session session) {
        this._session = session;
    }

    public NFSv41Session getSession() {
        return this._session;
    }

    public NFSv4StateHandler getStateHandler() {
        return this._stateHandler;
    }

    public SessionSlot getSessionSlot() {
        return this._slot;
    }

    public void setSessionSlot(SessionSlot slot) {
        this._slot = slot;
    }

    public boolean cacheThis() {
        return this._cacheThis;
    }

    public void setCacheThis(boolean cacheThis) {
        this._cacheThis = cacheThis;
    }

    public List<nfs_resop4> getCache() {
        return this._cache;
    }

    public void setCache(List<nfs_resop4> cache) {
        this._cache = cache;
    }

    public stateid4 currentStateid() throws ChimeraNFSException {
        if (this._currentStateid == null) {
            throw new BadStateidException("no current stateid");
        }
        return this._currentStateid;
    }

    public void currentStateid(stateid4 currentStateid) {
        this._currentStateid = currentStateid;
    }

    public ExportTable getExportTable() {
        return this._exportTable;
    }

    public ServerIdProvider getServerIdProvider() {
        return new ServerIdProvider(){

            @Override
            public server_owner4 getOwner() {
                server_owner4 owner = new server_owner4();
                owner.so_minor_id = new uint64_t(0L);
                owner.so_major_id = InetSocketAddresses.uaddrOf((InetSocketAddress)CompoundContext.this._callInfo.getTransport().getLocalSocketAddress()).getBytes(StandardCharsets.UTF_8);
                return owner;
            }

            @Override
            public byte[] getScope() {
                return "".getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public int getExchangeIdFlags() {
        return this._exchangeIdFlags;
    }

    private Principal principalOf(RpcCall call) {
        Class type = call.getCredential().type() == 6 ? KerberosPrincipal.class : UnixNumericUserPrincipal.class;
        return call.getCredential().getSubject().getPrincipals().stream().filter(type::isInstance).findFirst().orElse(NO_PRINCIPAL);
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return this.getRpcCall().getTransport().getRemoteSocketAddress();
    }

    public InetSocketAddress getLocalSocketAddress() {
        return this.getRpcCall().getTransport().getLocalSocketAddress();
    }

    public verifier4 getRebootVerifier() {
        return this._rebootVerifier;
    }
}

