/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.dcache.nfs.v4.xdr.sequenceid4;
import org.dcache.nfs.v4.xdr.sessionid4;
import org.dcache.nfs.v4.xdr.slotid4;

public class ClientSession {
    private final sessionid4 id;
    private final int maxRequests;
    private final BlockingQueue<SessionSlot> unusedSessionSlots = new LinkedBlockingQueue<SessionSlot>();

    public ClientSession(sessionid4 sessionid, int maxRequests) {
        this.id = sessionid;
        this.maxRequests = maxRequests;
        for (int i = 0; i < maxRequests; ++i) {
            this.unusedSessionSlots.add(new SessionSlot(i));
        }
    }

    public SessionSlot acquireSlot() throws IOException {
        try {
            return this.unusedSessionSlots.take();
        }
        catch (InterruptedException e) {
            InterruptedIOException eio = new InterruptedIOException(e.getMessage());
            eio.setStackTrace(e.getStackTrace());
            throw eio;
        }
    }

    public void releaseSlot(SessionSlot slot) {
        this.unusedSessionSlots.offer(slot);
    }

    public sessionid4 sessionId() {
        return this.id;
    }

    public int maxRequests() {
        return this.maxRequests;
    }

    public static class SessionSlot {
        private final slotid4 id;
        private int sequenceid = 0;

        public SessionSlot(int id) {
            this.id = new slotid4(id);
        }

        public slotid4 getId() {
            return this.id;
        }

        public sequenceid4 nextSequenceId() {
            return new sequenceid4(++this.sequenceid);
        }
    }
}

