/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dcache.nfs.nfsstat;
import org.dcache.nfs.v4.ClientSession;
import org.dcache.nfs.v4.xdr.CB_COMPOUND4args;
import org.dcache.nfs.v4.xdr.CB_COMPOUND4res;
import org.dcache.nfs.v4.xdr.CB_LAYOUTRECALL4args;
import org.dcache.nfs.v4.xdr.CB_NOTIFY_DEVICEID4args;
import org.dcache.nfs.v4.xdr.CB_SEQUENCE4args;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.callback_sec_parms4;
import org.dcache.nfs.v4.xdr.deviceid4;
import org.dcache.nfs.v4.xdr.fsid4;
import org.dcache.nfs.v4.xdr.layoutrecall4;
import org.dcache.nfs.v4.xdr.layoutrecall_file4;
import org.dcache.nfs.v4.xdr.layouttype4;
import org.dcache.nfs.v4.xdr.length4;
import org.dcache.nfs.v4.xdr.nfs_cb_argop4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.notify4;
import org.dcache.nfs.v4.xdr.notify_deviceid_delete4;
import org.dcache.nfs.v4.xdr.notifylist4;
import org.dcache.nfs.v4.xdr.offset4;
import org.dcache.nfs.v4.xdr.referring_call_list4;
import org.dcache.nfs.v4.xdr.sessionid4;
import org.dcache.nfs.v4.xdr.slotid4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.v4.xdr.uint64_t;
import org.dcache.nfs.v4.xdr.utf8str_cs;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.RpcAuth;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeNone;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeUnix;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.dcache.oncrpc4j.xdr.Xdr;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.dcache.oncrpc4j.xdr.XdrEncodingStream;
import org.dcache.oncrpc4j.xdr.XdrVoid;

public class ClientCB {
    private static final int CB_VERSION = 1;
    private final sessionid4 _session;
    private final int _minorVersion;
    private final RpcAuth _auth;
    private final int _highestSlotId;
    private final RpcCall _rpc;
    private final ClientSession _clientSession;

    ClientCB(RpcTransport transport, int program, int minorVersion, sessionid4 session, int maxrequests, callback_sec_parms4[] sec_parms) {
        this._minorVersion = minorVersion;
        this._session = session;
        switch (sec_parms[0].cb_secflavor) {
            case 0: {
                this._auth = new RpcAuthTypeNone();
                break;
            }
            case 1: {
                this._auth = new RpcAuthTypeUnix(sec_parms[0].cbsp_sys_cred.uid, sec_parms[0].cbsp_sys_cred.gid, sec_parms[0].cbsp_sys_cred.gids, sec_parms[0].cbsp_sys_cred.stamp, sec_parms[0].cbsp_sys_cred.machinename);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsuppotred security flavor");
            }
        }
        this._highestSlotId = maxrequests - 1;
        this._clientSession = new ClientSession(session, maxrequests);
        this._rpc = new RpcCall(program, 1, this._auth, transport);
    }

    public String toString() {
        return "tcp:///" + this._rpc;
    }

    public void cbPing() throws OncRpcException, IOException, TimeoutException {
        this._rpc.call(0, (XdrAble)XdrVoid.XDR_VOID, (XdrAble)XdrVoid.XDR_VOID, 1L, TimeUnit.SECONDS);
    }

    private XdrAble generateCompound(ClientSession.SessionSlot sessionSlot, String tag, nfs_cb_argop4 ... cbOperations) {
        CB_SEQUENCE4args cbSequence = new CB_SEQUENCE4args();
        cbSequence.csa_cachethis = false;
        cbSequence.csa_highest_slotid = new slotid4(this._highestSlotId);
        cbSequence.csa_sequenceid = sessionSlot.nextSequenceId();
        cbSequence.csa_slotid = sessionSlot.getId();
        cbSequence.csa_sessionid = this._session;
        cbSequence.csa_referring_call_lists = new referring_call_list4[0];
        CB_COMPOUND4args cbCompound = new CB_COMPOUND4args();
        cbCompound.argarray = new nfs_cb_argop4[cbOperations.length + 1];
        cbCompound.argarray[0] = new nfs_cb_argop4();
        cbCompound.argarray[0].argop = 11;
        cbCompound.argarray[0].opcbsequence = cbSequence;
        System.arraycopy(cbOperations, 0, cbCompound.argarray, 1, cbOperations.length);
        cbCompound.minorversion = new uint32_t(this._minorVersion);
        cbCompound.callback_ident = new uint32_t(0);
        cbCompound.tag = new utf8str_cs(tag);
        return cbCompound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cbLayoutRecallFsid() throws OncRpcException, IOException {
        CB_LAYOUTRECALL4args cbLayoutrecall = new CB_LAYOUTRECALL4args();
        cbLayoutrecall.clora_changed = true;
        cbLayoutrecall.clora_type = layouttype4.LAYOUT4_NFSV4_1_FILES.getValue();
        cbLayoutrecall.clora_iomode = 3;
        cbLayoutrecall.clora_recall = new layoutrecall4();
        cbLayoutrecall.clora_recall.lor_recalltype = 2;
        cbLayoutrecall.clora_recall.lor_fsid = new fsid4();
        cbLayoutrecall.clora_recall.lor_fsid.major = new uint64_t(17L);
        cbLayoutrecall.clora_recall.lor_fsid.minor = new uint64_t(17L);
        nfs_cb_argop4 opArgs = new nfs_cb_argop4();
        opArgs.argop = 5;
        opArgs.opcblayoutrecall = cbLayoutrecall;
        ClientSession.SessionSlot slot = this._clientSession.acquireSlot();
        try {
            XdrAble args = this.generateCompound(slot, "cb_layout_recall_fs", opArgs);
            this._rpc.call(1, args, (XdrAble)new CB_COMPOUND4res());
        }
        finally {
            this._clientSession.releaseSlot(slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cbLayoutRecallFile(nfs_fh4 fh, stateid4 stateid) throws OncRpcException, IOException {
        CB_LAYOUTRECALL4args cbLayoutrecall = new CB_LAYOUTRECALL4args();
        cbLayoutrecall.clora_changed = true;
        cbLayoutrecall.clora_type = layouttype4.LAYOUT4_NFSV4_1_FILES.getValue();
        cbLayoutrecall.clora_iomode = 3;
        cbLayoutrecall.clora_recall = new layoutrecall4();
        cbLayoutrecall.clora_recall.lor_recalltype = 1;
        cbLayoutrecall.clora_recall.lor_layout = new layoutrecall_file4();
        cbLayoutrecall.clora_recall.lor_layout.lor_fh = fh;
        cbLayoutrecall.clora_recall.lor_layout.lor_offset = new offset4(0L);
        cbLayoutrecall.clora_recall.lor_layout.lor_length = new length4(-1L);
        cbLayoutrecall.clora_recall.lor_layout.lor_stateid = stateid;
        nfs_cb_argop4 opArgs = new nfs_cb_argop4();
        opArgs.argop = 5;
        opArgs.opcblayoutrecall = cbLayoutrecall;
        ClientSession.SessionSlot slot = this._clientSession.acquireSlot();
        try {
            XdrAble args = this.generateCompound(slot, "cb_layout_recall_file", opArgs);
            CB_COMPOUND4res res = new CB_COMPOUND4res();
            this._rpc.call(1, args, (XdrAble)res);
            nfsstat.throwIfNeeded(res.status);
        }
        finally {
            this._clientSession.releaseSlot(slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cbDeleteDevice(deviceid4 id) throws OncRpcException, IOException {
        CB_NOTIFY_DEVICEID4args cbDeleteDeciveId = new CB_NOTIFY_DEVICEID4args();
        cbDeleteDeciveId.cnda_changes = new notify4[1];
        cbDeleteDeciveId.cnda_changes[0] = new notify4();
        cbDeleteDeciveId.cnda_changes[0].notify_mask = bitmap4.of(2);
        notify_deviceid_delete4 deleteDevice = new notify_deviceid_delete4();
        deleteDevice.ndd_layouttype = layouttype4.LAYOUT4_NFSV4_1_FILES.getValue();
        deleteDevice.ndd_deviceid = id;
        try (Xdr xdr = new Xdr(32);){
            xdr.beginEncoding();
            deleteDevice.xdrEncode((XdrEncodingStream)xdr);
            xdr.endEncoding();
            byte[] b = xdr.getBytes();
            cbDeleteDeciveId.cnda_changes[0].notify_vals = new notifylist4(b);
        }
        nfs_cb_argop4 opArgs = new nfs_cb_argop4();
        opArgs.argop = 14;
        opArgs.opcbnotify_deviceid = cbDeleteDeciveId;
        ClientSession.SessionSlot slot = this._clientSession.acquireSlot();
        try {
            XdrAble args = this.generateCompound(slot, "cb_delete_device", opArgs);
            CB_COMPOUND4res res = new CB_COMPOUND4res();
            this._rpc.call(1, args, (XdrAble)res);
            nfsstat.throwIfNeeded(res.status);
        }
        finally {
            this._clientSession.releaseSlot(slot);
        }
    }
}

