/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.status.BadOwnerException;
import org.dcache.nfs.v4.NfsIdMapping;

public class CachingIdmap
implements NfsIdMapping {
    private final NfsIdMapping _inner;
    private final LoadingCache<String, Integer> _uidByNameCache;
    private final LoadingCache<String, Integer> _gidByNameCache;
    private final LoadingCache<Integer, String> _userNameByIdCache;
    private final LoadingCache<Integer, String> _groupNameByIdCache;

    public CachingIdmap(NfsIdMapping idmapd, int size, long timeout) {
        this._inner = idmapd;
        this._uidByNameCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, TimeUnit.SECONDS).softValues().maximumSize((long)size).build((CacheLoader)new ForwardUidMapping());
        this._gidByNameCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, TimeUnit.SECONDS).softValues().maximumSize((long)size).build((CacheLoader)new ForwardGidMapping());
        this._userNameByIdCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, TimeUnit.SECONDS).softValues().maximumSize((long)size).build((CacheLoader)new ReverseUidMapping());
        this._groupNameByIdCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, TimeUnit.SECONDS).softValues().maximumSize((long)size).build((CacheLoader)new ReverseGidMapping());
    }

    @Override
    public String uidToPrincipal(int id) {
        return (String)this._userNameByIdCache.getUnchecked((Object)id);
    }

    @Override
    public String gidToPrincipal(int id) {
        return (String)this._groupNameByIdCache.getUnchecked((Object)id);
    }

    @Override
    public int principalToUid(String principal) {
        return (Integer)this._uidByNameCache.getUnchecked((Object)principal);
    }

    @Override
    public int principalToGid(String principal) {
        return (Integer)this._gidByNameCache.getUnchecked((Object)principal);
    }

    private class ForwardUidMapping
    extends CacheLoader<String, Integer> {
        private ForwardUidMapping() {
        }

        public Integer load(String s) throws BadOwnerException {
            return CachingIdmap.this._inner.principalToUid(s);
        }
    }

    private class ForwardGidMapping
    extends CacheLoader<String, Integer> {
        private ForwardGidMapping() {
        }

        public Integer load(String s) throws BadOwnerException {
            return CachingIdmap.this._inner.principalToGid(s);
        }
    }

    private class ReverseUidMapping
    extends CacheLoader<Integer, String> {
        private ReverseUidMapping() {
        }

        public String load(Integer id) {
            return CachingIdmap.this._inner.uidToPrincipal(id);
        }
    }

    private class ReverseGidMapping
    extends CacheLoader<Integer, String> {
        private ReverseGidMapping() {
        }

        public String load(Integer id) {
            return CachingIdmap.this._inner.gidToPrincipal(id);
        }
    }
}

