/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Properties;
import org.dcache.nfs.status.NoGraceException;
import org.dcache.nfs.status.ReclaimBadException;
import org.dcache.nfs.v4.ClientRecoveryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyDBClientStore
implements ClientRecoveryStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BerkeleyDBClientStore.class);
    private static final String CLIENT_DB = "nfs-client-db";
    private static final String CLIENT_DB_RECOVER = "nfs-client-db.new";
    private final Environment env;
    private Database clientDatabase;
    private Database clientRecoveryDatabase;
    private final DatabaseConfig dbConfig;
    private final CursorConfig config = new CursorConfig();
    private final Instant bootTime = Instant.now();

    public BerkeleyDBClientStore(File dir) {
        this(dir, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BerkeleyDBClientStore(File dir, Properties properties) {
        EnvironmentConfig envConfig = new EnvironmentConfig(properties);
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);
        envConfig.setReadOnly(false);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.env = new Environment(dir, envConfig);
        this.dbConfig = new DatabaseConfig();
        this.dbConfig.setTransactional(true);
        this.dbConfig.setAllowCreate(true);
        this.dbConfig.setReadOnly(false);
        this.config.setReadCommitted(true);
        this.clientRecoveryDatabase = this.env.openDatabase(null, CLIENT_DB, this.dbConfig);
        this.clientDatabase = this.env.openDatabase(null, CLIENT_DB_RECOVER, this.dbConfig);
        Transaction tx = this.env.beginTransaction(null, null);
        try (Cursor cursor = this.clientDatabase.openCursor(tx, this.config);){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                this.clientRecoveryDatabase.putNoOverwrite(tx, key, data);
                cursor.delete();
            }
        }
        finally {
            tx.commit();
        }
        this.dump();
    }

    @Override
    public synchronized void addClient(byte[] client) {
        Instant now = Instant.now();
        DatabaseEntry key = new DatabaseEntry(client);
        DatabaseEntry data = new DatabaseEntry();
        LongBinding.longToEntry((long)now.toEpochMilli(), (DatabaseEntry)data);
        LOGGER.debug("New client record [{}] at {}", (Object)new String(client, StandardCharsets.UTF_8), (Object)now);
        this.clientDatabase.put(null, key, data);
    }

    @Override
    public synchronized void removeClient(byte[] client) {
        DatabaseEntry key = new DatabaseEntry(client);
        this.clientDatabase.delete(null, key);
        if (this.clientRecoveryDatabase != null) {
            this.clientRecoveryDatabase.delete(null, key);
        }
    }

    @Override
    public synchronized void reclaimClient(byte[] client) {
        if (this.clientRecoveryDatabase == null) {
            return;
        }
        DatabaseEntry key = new DatabaseEntry(client);
        LOGGER.debug("Removing recovery record for client [{}]", (Object)new String(client, StandardCharsets.UTF_8));
        this.clientRecoveryDatabase.delete(null, key);
        if (this.clientRecoveryDatabase.count() == 0L) {
            LOGGER.debug("No more client to recover - ending grace period.");
            this.reclaimComplete();
        }
    }

    @Override
    public synchronized void wantReclaim(byte[] client) throws NoGraceException, ReclaimBadException {
        if (this.clientRecoveryDatabase == null) {
            throw new NoGraceException("Grace period expired");
        }
        DatabaseEntry key = new DatabaseEntry(client);
        DatabaseEntry data = new DatabaseEntry();
        LOGGER.debug("Removing recovery record for client [{}]", (Object)new String(client, StandardCharsets.UTF_8));
        OperationStatus status = this.clientRecoveryDatabase.get(null, key, data, LockMode.READ_COMMITTED);
        if (status != OperationStatus.SUCCESS) {
            LOGGER.debug("No record for client [{}]", (Object)new String(client, StandardCharsets.UTF_8));
            throw new ReclaimBadException("No pre-reboot record found");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized boolean waitingForReclaim() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        Transaction tx = this.env.beginTransaction(null, null);
        try (Cursor cursor = this.clientRecoveryDatabase.openCursor(tx, this.config);){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                Instant clientCreationTime = Instant.ofEpochMilli(LongBinding.entryToLong((DatabaseEntry)data));
                LOGGER.info("NFS client record to recover: [{}], {}", (Object)new String(key.getData(), StandardCharsets.UTF_8), (Object)clientCreationTime);
            }
        }
        finally {
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reclaimComplete() {
        if (this.clientRecoveryDatabase == null) {
            return;
        }
        Transaction tx = this.env.beginTransaction(null, null);
        try {
            try (Cursor cursor = this.clientRecoveryDatabase.openCursor(tx, this.config);){
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                    Instant clientCreationTime = Instant.ofEpochMilli(LongBinding.entryToLong((DatabaseEntry)data));
                    LOGGER.info("Dropping expired recovery record: [{}], {}", (Object)new String(key.getData(), StandardCharsets.UTF_8), (Object)clientCreationTime);
                }
            }
            this.clientDatabase.close();
            this.clientRecoveryDatabase.close();
            this.clientRecoveryDatabase = null;
            this.env.removeDatabase(tx, CLIENT_DB);
            this.env.renameDatabase(tx, CLIENT_DB_RECOVER, CLIENT_DB);
            this.clientDatabase = this.env.openDatabase(tx, CLIENT_DB, this.dbConfig);
        }
        finally {
            tx.commit();
        }
    }

    @Override
    public synchronized void close() {
        this.clientDatabase.close();
        if (this.clientRecoveryDatabase != null) {
            this.clientRecoveryDatabase.close();
            this.clientRecoveryDatabase = null;
        }
    }
}

