/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadSessionException;
import org.dcache.nfs.status.BadStateidException;
import org.dcache.nfs.status.BadXdrException;
import org.dcache.nfs.status.ExpiredException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.status.OpIllegalException;
import org.dcache.nfs.status.ResourceException;
import org.dcache.nfs.status.ServerFaultException;
import org.dcache.nfs.status.StaleClientidException;
import org.dcache.nfs.status.StaleStateidException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.OperationExecutor;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_opnum4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperationExecutor
implements OperationExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperationExecutor.class);

    @Override
    public nfs_resop4 execute(CompoundContext context, nfs_argop4 args) throws IOException, OncRpcException {
        AbstractNFSv4Operation op = this.getOperation(args);
        nfs_resop4 opResult = nfs_resop4.resopFor(args.argop);
        try {
            op.process(context, opResult);
        }
        catch (NfsIoException | ResourceException | ServerFaultException e) {
            LOGGER.error("NFS server fault: op: {} : {}", (Object)nfs_opnum4.toString(args.argop), (Object)e.getMessage());
            opResult.setStatus(e.getStatus());
        }
        catch (BadXdrException | InvalException | OpIllegalException e) {
            LOGGER.warn("Faulty NFS client: op: {} : {}", (Object)nfs_opnum4.toString(args.argop), (Object)e.getMessage());
            opResult.setStatus(e.getStatus());
        }
        catch (BadSessionException | BadStateidException | ExpiredException | StaleClientidException | StaleStateidException e) {
            LOGGER.info("Lost client state: op: {} : {}", (Object)nfs_opnum4.toString(args.argop), (Object)e.getMessage());
            opResult.setStatus(e.getStatus());
        }
        catch (ChimeraNFSException e) {
            opResult.setStatus(e.getStatus());
        }
        catch (OncRpcException e) {
            opResult.setStatus(10036);
            LOGGER.warn("Bad xdr: {}: ", (Object)e.getMessage());
        }
        return opResult;
    }

    protected abstract AbstractNFSv4Operation getOperation(nfs_argop4 var1);
}

