/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.util;

import java.time.Clock;
import java.util.Date;

public class CacheElement<V> {
    private final long _maxLifeTime;
    private final long _idleTime;
    private final long _creationTime;
    private long _lastAccessTime;
    private final V _inner;
    private final Clock _clock;

    CacheElement(V inner, Clock clock, long maxLifeTime, long idleTime) {
        this._clock = clock;
        this._lastAccessTime = this._creationTime = this._clock.millis();
        this._inner = inner;
        this._maxLifeTime = maxLifeTime;
        this._idleTime = idleTime;
    }

    public V getObject() {
        this._lastAccessTime = this._clock.millis();
        return this._inner;
    }

    public V peekObject() {
        return this._inner;
    }

    public boolean validAt(long time) {
        return time - this._lastAccessTime < this._idleTime && time - this._creationTime < this._maxLifeTime;
    }

    public String toString() {
        long now = this._clock.millis();
        return String.format("Element: [%s], created: %s, last access: %s, life time %d, idle: %d, max idle: %d", this._inner.toString(), new Date(this._creationTime), new Date(this._lastAccessTime), this._maxLifeTime, now - this._lastAccessTime, this._idleTime);
    }
}

