/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public abstract class InetAddressMatcher
implements Predicate<InetAddress> {
    private final String pattern;

    protected InetAddressMatcher(String pattern) {
        this.pattern = pattern;
    }

    public boolean match(InetAddress addr) {
        return this.test(addr);
    }

    public String getPattern() {
        return this.pattern;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.pattern);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetAddressMatcher other = (InetAddressMatcher)obj;
        return Objects.equals(this.pattern, other.pattern);
    }

    public static InetAddressMatcher forPattern(String s) throws UnknownHostException {
        String[] hostAndMask = s.split("/");
        Preconditions.checkArgument((hostAndMask.length < 3 ? 1 : 0) != 0, (Object)("Invalid host specification: " + s));
        if (!InetAddresses.isInetAddress((String)hostAndMask[0])) {
            Preconditions.checkArgument((hostAndMask.length == 1 ? 1 : 0) != 0, (Object)("Invalid host specification (hostname with mask): " + s));
            if (s.indexOf(42) != -1 || s.indexOf(63) != -1) {
                return new RegexpNameMatcher(InetAddressMatcher.toRegExp(s));
            }
            return new HostNameMatcher(s);
        }
        InetAddress net = InetAddresses.forString((String)hostAndMask[0]);
        if (hostAndMask.length == 2) {
            return new IpAddressMatcher(s, net, Integer.parseInt(hostAndMask[1]));
        }
        return new IpAddressMatcher(s, net);
    }

    private static String toRegExp(String s) {
        return s.replace(".", "\\.").replace("?", ".").replace("*", ".*");
    }

    public static class RegexpNameMatcher
    extends InetAddressMatcher {
        private final Pattern regexpPattern;

        public RegexpNameMatcher(String pattern) {
            super(pattern);
            this.regexpPattern = Pattern.compile(pattern);
        }

        @Override
        public boolean test(InetAddress ip) {
            return this.regexpPattern.matcher(ip.getHostName()).matches();
        }
    }

    public static class HostNameMatcher
    extends InetAddressMatcher {
        HostNameMatcher(String hostname) {
            super(hostname);
        }

        @Override
        public boolean test(InetAddress ip) {
            try {
                InetAddress[] addrs;
                for (InetAddress addr : addrs = InetAddress.getAllByName(this.getPattern())) {
                    if (!addr.equals(ip)) continue;
                    return true;
                }
            }
            catch (UnknownHostException e) {
                return false;
            }
            return false;
        }
    }

    public static class IpAddressMatcher
    extends InetAddressMatcher {
        private static final int IPv4_FULL_MASK = 32;
        private static final int IPv6_FULL_MASK = 128;
        private static final int IPv6_HALF_MASK = 64;
        private final byte[] netBytes;
        private final int mask;

        private static int fullMaskOf(InetAddress address) {
            if (address instanceof Inet4Address) {
                return 32;
            }
            if (address instanceof Inet6Address) {
                return 128;
            }
            throw new IllegalArgumentException("Unsupported Inet type: " + address.getClass().getName());
        }

        public IpAddressMatcher(String pattern, InetAddress subnet) {
            this(pattern, subnet, IpAddressMatcher.fullMaskOf(subnet));
        }

        public IpAddressMatcher(String pattern, InetAddress subnet, int mask) {
            super(pattern);
            this.netBytes = subnet.getAddress();
            this.mask = mask;
            Preconditions.checkArgument((mask >= 0 ? 1 : 0) != 0, (Object)"Netmask should be positive");
            if (this.netBytes.length == 4) {
                Preconditions.checkArgument((mask <= 32 ? 1 : 0) != 0, (Object)"Netmask for ipv4 can't be bigger than32");
            } else {
                Preconditions.checkArgument((mask <= 128 ? 1 : 0) != 0, (Object)"Netmask for ipv6 can't be bigger than128");
            }
        }

        @Override
        public boolean test(InetAddress ip) {
            byte[] ipBytes = ip.getAddress();
            if (ipBytes.length != this.netBytes.length) {
                return false;
            }
            if (ipBytes.length == 4) {
                int netAsBytes;
                int ipAsInt = Ints.fromByteArray((byte[])ipBytes);
                return (ipAsInt ^ (netAsBytes = Ints.fromByteArray((byte[])this.netBytes))) >> 32 - this.mask == 0;
            }
            long ipAsLong0 = Longs.fromBytes((byte)ipBytes[0], (byte)ipBytes[1], (byte)ipBytes[2], (byte)ipBytes[3], (byte)ipBytes[4], (byte)ipBytes[5], (byte)ipBytes[6], (byte)ipBytes[7]);
            long netAsLong0 = Longs.fromBytes((byte)this.netBytes[0], (byte)this.netBytes[1], (byte)this.netBytes[2], (byte)this.netBytes[3], (byte)this.netBytes[4], (byte)this.netBytes[5], (byte)this.netBytes[6], (byte)this.netBytes[7]);
            if (this.mask > 64) {
                long ipAsLong1 = Longs.fromBytes((byte)ipBytes[8], (byte)ipBytes[9], (byte)ipBytes[10], (byte)ipBytes[11], (byte)ipBytes[12], (byte)ipBytes[13], (byte)ipBytes[14], (byte)ipBytes[15]);
                long netAsLong1 = Longs.fromBytes((byte)this.netBytes[8], (byte)this.netBytes[9], (byte)this.netBytes[10], (byte)this.netBytes[11], (byte)this.netBytes[12], (byte)this.netBytes[13], (byte)this.netBytes[14], (byte)this.netBytes[15]);
                return ipAsLong0 == netAsLong0 & (ipAsLong1 ^ netAsLong1) >> 128 - this.mask == 0L;
            }
            return (ipAsLong0 ^ netAsLong0) >> 64 - this.mask == 0L;
        }
    }
}

